package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;

import com.zing.zalo.zalosdk.core.http.HttpClientFactory;
import com.zing.zalo.zalosdk.core.log.Log;

import java.util.List;


public class AppTracker {

	private BaseAppInfoStorage storage;
	private DeviceTracking deviceTracker;
	private HandlerThread thread;
	private Handler handler;
	private Context context;
	private String appId;
	int submitRetry = 0;
	
	List<String> packageNames;
	List<String> installedPackagedNames;
	long expiredTime;
	String scanId;
	HttpClientFactory mHttpClientFactory = new HttpClientFactory();
	private boolean waitDeviceIdToSubmitInstallApps = false;

	private Listener listener;

	public AppTracker(Context context, BaseAppInfoStorage storage, String appId, DeviceTracking deviceTracker) {
		this.storage = storage;
		this.context = context.getApplicationContext();
		this.deviceTracker = deviceTracker;
		this.appId = appId;

		Log.d("AppTracker", "AppTracker has been disable");
		
//		thread = new HandlerThread("zdt-app-tracker", HandlerThread.MIN_PRIORITY);
//		thread.start();
//
//		handler = new Handler(thread.getLooper());
//		handler.post(new Runnable() {
//
//			@Override
//			public void run() {
//				try {
//					if (needToScanInstalledApp() &&
//							downloadPackageNames() &&
//							scanInstalledApp() &&
//							submitInstalledApp())
//						cleanUp();
//				} catch (Exception ex) {
//					Log.e(ex);
//					cleanUp();
//				}
//			}
//		});
//		Log.v("start app tracker thread");
	}
//
//	private boolean needToScanInstalledApp() {
//		long expiredTime = storage.getTrackingAppInstallExpireTime();
//		if (expiredTime > System.currentTimeMillis()) {
//			return false;
//		}
//
//		return true;
//	}
//
//	private boolean downloadPackageNames() throws JSONException {
//		try {
//			Log.i("debuglog","downloading package name");
//			String url = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_TRACKING_URL);
//
//			// get sync app url
//			HttpClientRequest request = new HttpClientRequest(Type.GET, url);
//			request.addParams("pl", "android");
//			request.addParams("appId", appId);
//			request.addParams("zdId", deviceTracker.getDeviceId());
//			request.addParams("sdkId", deviceTracker.getSDKId());
//			JSONObject jsonObject = request.getJSON();
//
//			if (jsonObject == null) {
//				cleanUp();
//				return false;
//			}
//			int errorCode = jsonObject.getInt("error");
//			if (errorCode < 0) {
//				cleanUp();
//				return false;
//			}
//
//			JSONObject data = jsonObject.getJSONObject("data");
//			JSONArray japps = data.optJSONArray("apps");
//			final List<String> packagedNames = new ArrayList<String>();
//			for (int i = 0; i < japps.length(); i++) {
//				packagedNames.add(japps.getString(i));
//			}
//
//			expiredTime = data.optLong("expiredTime") + System.currentTimeMillis();
//			scanId = data.optString("scanId", "");
//			this.packageNames = packagedNames;
//
//			Log.i("debuglog", Constant.LOG_TAG, "downloaded %d packaged name %d scanId %s", packagedNames.size(), expiredTime, scanId);
//		}catch (Exception ex){
//			ex.printStackTrace();
//		}
//		return true;
//	}
//
//	private boolean scanInstalledApp() {
//		try {
//			if (packageNames == null || packageNames.size() == 0) {
//				cleanUp();
//				return false;
//			}
//
//			installedPackagedNames = new ArrayList<>();
//
//			//do scan
//			Log.v("scaning package name");
//			for (int i = 0; i < packageNames.size(); i++) {
//				String str = packageNames.get(i);
//				if (Utils.isPackageExisted(context, str)) {
//					installedPackagedNames.add(str);
//					Log.v("found installed app " + str);
//				}
//			}
//
//			packageNames.clear();
//		}catch (Exception ex){
//			ex.printStackTrace();
//		}
//		return true;
//	}
//
//	private boolean submitInstalledApp() throws Exception{
//		try {
//			if (installedPackagedNames == null || installedPackagedNames.size() == 0 || TextUtils.isEmpty(scanId) || submitRetry >= 5) {
//				cleanUp();
//				return false;
//			}
//
//			//send by block?
//			JSONArray appData = Utils.listToJSONObject(installedPackagedNames);
//
//			String zdId = deviceTracker.getDeviceId();
//			String sdkId = deviceTracker.getSDKId();
//			String privateKey = deviceTracker.getPrivateKey();
//
//			//thuannm 26-March-2019: add must to have zdId to submit installedApp
//			try {
//				if (TextUtils.isEmpty(zdId)) {
//					Log.i("debuglog", "submitInstalledApp-zdId == null. waiting deviceId to submit");
//					waitDeviceIdToSubmitInstallApps = true;
//					DeviceTracking.getInstance().getDeviceId(new DeviceTracking.GetInfoListener() {
//						@Override
//						public void onGetDeviceIdComplete(String deviceId) {
//							if (!TextUtils.isEmpty(deviceId)) {
//								try {
//									if (waitDeviceIdToSubmitInstallApps) {
//										Log.i("debuglog", "submitInstalledApp  ------ has zdId  ---  onGetDeviceIdComplete ---- resubmit install app -----");
//										submitInstalledApp();
//									}
//									waitDeviceIdToSubmitInstallApps = false;
//								}catch (Exception ex){
//									ex.printStackTrace();
//								}
//							}
//						}
//					});
//					return false;//thuannm 26 March 2019: no zdid waiting zdid to submit again
//				}
//			}catch (Exception ex){
//				ex.printStackTrace();
//			}
//
//			if (TextUtils.isEmpty(sdkId) || TextUtils.isEmpty(privateKey)) {
//				submitRetry += 1;
//				handler.postDelayed(new Runnable() {
//
//					@Override
//					public void run() {
//						try {
//							submitInstalledApp();
//						} catch (Exception ex) {
//							Log.e(ex);
//						}
//
//					}
//				}, 5000);
//				return false;
//			}
//
//			String url = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_APP_TRACKING_ID_URL);
//			url = url + "?et=0&sdkId=" + sdkId + "&gzip=0";
//
//			JSONObject jsonData = new JSONObject();
//			jsonData.put("pl", "android");
//			jsonData.put("appId", appId);
//			jsonData.put("an", AppInfo.getAppName(context));
//			jsonData.put("av", AppInfo.getVersionName(context));
//			jsonData.put("oauthCode", this.storage.getOAuthCode());
//			jsonData.put("osv", Build.VERSION.RELEASE);
//			jsonData.put("sdkv", Constant.VERSION);
//			jsonData.put("zdId", zdId);
//			jsonData.put("scanId", scanId);
//			jsonData.put("apps", appData);
//
//			String str = jsonData.toString();
//			Log.i("debuglog", "submit submitInstalledApp data: " + str);
//			HttpClientRequest request = mHttpClientFactory.newRequest(Type.POST_MULIIPART, url);
//			request.setMultipartFile("data.dat", "zce", str.getBytes());
//
//			JSONObject jsonObject = request.getJSON();
//			if (jsonObject != null) {
//				Log.i("debuglog","submit app tracking to server with result " + jsonObject.toString());
//				int error_code = jsonObject.getInt("error");
//				if (error_code == 0) {
//					storage.setTrackingAppInstallExpireTime(expiredTime);
//				}
//			}
//		}catch (Exception ex){
//			ex.printStackTrace();
//		}
//		return true;
//	}
//
	private void cleanUp() {
		if(thread != null) {
			thread.quit();
			thread = null;
			handler = null;

			if(listener != null) {
				listener.onAppTrackerCompleted(installedPackagedNames != null, expiredTime, scanId, packageNames, installedPackagedNames);
			}
		}
	}


	public void setListener(Listener listener) {
		this.listener = listener;
	}

	public interface Listener {
		void onAppTrackerCompleted(boolean didRun, long expireTime, String scanId, List<String> pkgNames, List<String> installedApp);
	}
}
