package com.zing.zalo.zalosdk;

import android.app.Application;

import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;

public class ZaloSDKCore {
   public static void enableWriteLogFile(boolean mode) {
      Log.LOG_WRITABLE = mode;
   }
   public static void init(Application app) {
      ZaloSDKContext.init(app);
      initServices(app);
   }

   private static void initServices(final Application ctx) {
      ServiceMapManager.getInstance().load(ctx);
      String appID = AppInfo.getAppId(ctx);
      final BaseAppInfoStorage storage = new BaseAppInfoStorage(ctx);
      final DeviceTracking dt = DeviceTracking.getInstance();
      dt.initDeviceTracking(ctx, storage, appID);
      dt.getDeviceId(new DeviceTracking.GetInfoListener() {
         @Override
         public void onGetDeviceIdComplete(String deviceId) {
            SettingsManager.getInstance().init(ctx, deviceId);
         }
      });

   }
}
