package com.zing.zalo.zalosdk.core.log;

import android.content.Context;
import android.os.Environment;

import com.zing.zalo.zalosdk.ZaloSDKContext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Locale;


public class Log {
    public static Boolean LOG_WRITABLE = false;
    private static final String LOG_FILE_NAME = "zalosdk-log-trace.txt";

    private static final String LOG_TAG = "ZDK"; //default log tag
    public static final int VERBOSE = android.util.Log.VERBOSE;
    public static final int DEBUG = android.util.Log.DEBUG;
    public static final int INFO = android.util.Log.INFO;
    public static final int WARN = android.util.Log.WARN;
    public static final int ERROR = android.util.Log.ERROR;
    private static int logLevel = android.util.Log.WARN;//thuan 19 Sept 2018: turn off log

    public static void setLogLevel(final int logLevel) {
        Log.logLevel = logLevel;
    }

    public static int getLogLevel() {
        return Log.logLevel;
    }

    public static void d(String msg) {
        d(LOG_TAG, msg);
    }

    public static void d(String format, Object... args) {
        d(LOG_TAG, format, args);
    }

    public static void d(String tag, String msg) {
        log(DEBUG, tag, msg);
    }

    public static void d(Class<?> tag, String msg) {
        log(DEBUG, tag.getSimpleName(), msg);
    }

    public static void d(String tag, String format, Object... args) {
        log(DEBUG, tag, format, args);
    }

    public static void d(Class<?> tag, String format, Object... args) {
        log(DEBUG, tag.getSimpleName(), format, args);
    }

    public static void e(String msg) {
        e(LOG_TAG, msg);
    }

    public static void e(String format, Object... args) {
        e(LOG_TAG, format, args);
    }

    public static void e(String tag, String msg) {
        log(ERROR, tag, msg);
    }

    public static void e(Class<?> tag, String msg) {
        log(ERROR, tag.getSimpleName(), msg);
    }

    public static void e(String tag, String format, Object... args) {
        log(ERROR, tag, format, args);
    }

    public static void e(Class<?> tag, String format, Object... args) {
        log(ERROR, tag.getSimpleName(), format, args);
    }

    public static void e(Exception ex) {
        e(LOG_TAG, ex);
    }

    public static void e(String tag, Exception ex) {
        String msg = android.util.Log.getStackTraceString(ex);
        log(ERROR, tag, msg);
    }

    public static void e(Class<?> tag, Exception ex) {
        String msg = android.util.Log.getStackTraceString(ex);
        log(ERROR, tag.getSimpleName(), msg);
    }

    public static void i(String msg) {
        i(LOG_TAG, msg);
    }

    public static void i(String format, Object... args) {
        i(LOG_TAG, format, args);
    }

    public static void i(String tag, String msg) {
        log(INFO, tag, msg);
    }

    public static void i(Class<?> tag, String msg) {
        log(INFO, tag.getSimpleName(), msg);
    }

    public static void i(String tag, String format, Object... args) {
        log(INFO, tag, format, args);
    }

    public static void i(Class<?> tag, String format, Object... args) {
        log(INFO, tag.getSimpleName(), format, args);
    }

    public static void v(String msg) {
        v(LOG_TAG, msg);
    }

    public static void v(String format, Object... args) {
        v(LOG_TAG, format, args);
    }

    public static void v(String tag, String msg) {
        log(VERBOSE, tag, msg);
    }

    public static void v(Class<?> tag, String msg) {
        log(VERBOSE, tag.getSimpleName(), msg);
    }

    public static void v(String tag, String format, Object... args) {
        log(VERBOSE, tag, format, args);
    }

    public static void v(Class<?> tag, String format, Object... args) {
        log(VERBOSE, tag.getSimpleName(), format, args);
    }

    public static void w(String msg) {
        w(LOG_TAG, msg);
    }

    public static void w(String format, Object... args) {
        w(LOG_TAG, format, args);
    }

    public static void w(String tag, String msg) {
        log(WARN, tag, msg);
    }

    public static void w(Class<?> tag, String msg) {
        log(WARN, tag.getSimpleName(), msg);
    }

    public static void w(String tag, String format, Object... args) {
        log(WARN, tag, format, args);
    }

    public static void w(Class<?> tag, String format, Object... args) {
        log(WARN, tag.getSimpleName(), format, args);
    }


    private static void log(int priority, String tag, String format, Object... args) {
        if (format == null) return;

        String msg = String.format(Locale.getDefault(), format, args);
        log(priority, tag, msg);
        writeLogFile(priority, tag, msg);
    }

    private static void log(int priority, String tag, String msg) {
        if (priority < logLevel) return;
        android.util.Log.println(priority, tag, msg);
        writeLogFile(priority, tag, msg);
    }

    private static void writeLogFile(int priority, String tag, String msg) {
        if (LOG_WRITABLE) {
            if (priority == ERROR || priority == WARN) {
                writeToFile(tag + "\n" + "\t" + msg + "\n\n");
            }
        } else {
            removeLogFileInDevice();
        }
    }

    private static void removeLogFileInDevice() {
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/com.google.android.zdt.data/" + LOG_FILE_NAME;
        File f = new File(path);
        f.getParentFile().mkdirs();
        if (f.exists()) {
            f.delete();
        }
    }

    private static void writeToFile(String content) {
        // write external storage
        File f;
        try {
            f = prepareFileInExternalStore();
            writeFileData(content, f);
        } catch (Exception e) {
        }
    }

    private static void writeFileData(String content, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f, true);
        OutputStreamWriter streamWriter = new OutputStreamWriter(fos);
        streamWriter.write(content);
        streamWriter.close();
        fos.flush();
        fos.close();
    }

    private static File prepareFileInExternalStore() {
        Context applicationContext= ZaloSDKContext.getInstance().getApplicationContext();

        if (applicationContext == null ) {
            return null;
        }
        String filePath = applicationContext.getExternalFilesDir(null) + LOG_FILE_NAME;
        File f = new File(filePath);
        f.getParentFile().mkdirs();
        if (!f.exists()) {
            try {
                f.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }


}
