package com.zing.zalo.zalosdk.core.type;

public enum EventType {
  OPEN_APP(1),
  DEEP_LINKING(2),
  SHARE(3),
  OPEN_APP_BY_NOTIFICATION(4),
  RECEIVE_NOTIFICATION(5),
  POST_FEED(6),
  SEND_APP_REQUEST(7),
  SEND_MSG(8),
  SEND_OA_MSG(9),
  GET_FRIEND(10),
  GET_INVITABLE_FRIEND(11),
  GET_PROFILE(12),
  AUTHEN(13),
  RECOVERY(14),
  PROTECT_ACC(15),
  START_SCREEN(16),
  CRASH_LOG(17);

  int code;
  EventType(int code) {
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  public String getEventName() {
    if (code == 1) {
      return "open_app";

    } else if (code == 2) {
      return "deep_linking";
    } else if (code == 3) {
      return "share";
    }else if (code == 4) {
      return "open_app_by_notification";
    }else if (code == 5) {
      return "receive_notification";
    }else if (code == 6) {
      return "post_feed";
    }else if (code == 7) {
      return "send_app_request";
    }else if (code == 8) {
      return "send_msg";
    }else if (code == 9) {
      return "send_oa_msg";
    }else if (code == 10) {
      return "get_friend";
    }else if (code == 11) {
      return "get_invitable_friend";
    }else if (code == 12) {
      return "get_profile";
    }else if (code == 13) {
      return "authen";
    }else if (code == 14) {
      return "recovery";
    }else if (code == 15) {
      return "protect_acc";
    } else if (code == 16) {
      return "start_screen";
    } else {
      return "crash_log";
    }

  }

}
