package com.zing.zalo.zalosdk.core.servicemap;

import android.content.Context;
import com.zing.zalo.zalosdk.core.helper.Storage;

public class ServiceMapStorage extends Storage {

    private final String PREF_KEY_URL_OAUTH = "PREFERECE_KEY_URL_OAUTH";
    private final String PREF_KEY_URL_CENTRALIZED = "PREFERECE_KEY_URL_CENTRALIZED";
    private final String PREF_KEY_URL_GRAPH = "PREFERECE_KEY_URL_GRAPH";
    private final String PREF_EXPIRE_TIME = "PREFERCE_EXPIRE_TIME";


    public ServiceMapStorage(Context c) {
        super(c);
    }

    public String getKeyUrlOauth() {
        return getString(PREF_KEY_URL_OAUTH);
    }

    public String getKeyUrlCentralized() {
        return getString(PREF_KEY_URL_CENTRALIZED);
    }

    public String getKeyUrlGraph() {
        return getString(PREF_KEY_URL_GRAPH);
    }

    public long getExpireTime() {
        return getLong(PREF_EXPIRE_TIME);
    }

    public void setKeyUrlOauth(String urlOauth) {
        setString(PREF_KEY_URL_OAUTH, urlOauth);
    }

    public void setKeyUrlCentralized(String urlGraph)  {
        setString(PREF_KEY_URL_CENTRALIZED, urlGraph);
    }

    public void setKeyUrlGraph(String urlCentralized) {
        setString(PREF_KEY_URL_GRAPH, urlCentralized);
    }

    public void setExpireTime(long expireTime) {
        setLong(PREF_EXPIRE_TIME, expireTime);
    }


}
