package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.AsyncTask;

import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.ref.WeakReference;

import static com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager.KEY_URL_CENTRALIZED;

public class GetPreloadSettingAsyncTask extends AsyncTask<Context, Void, Boolean> {

    WeakReference<Context> weakContext;
    String deviceId;
    Callback callback;
    public interface Callback {
        void onSuccess();
        void onFailed(int errorCode, String errorMsg);
    }

    public GetPreloadSettingAsyncTask(Context _context, Callback cb, String _zdId) {
        weakContext = new WeakReference<>(_context);
        callback = cb;
        deviceId= _zdId;
    }

    @Override
    protected Boolean doInBackground(Context... contexts) {
        try {
            Context context = weakContext.get();

            if (context == null) {
                callback.onFailed(-1, "Error message: GetPreloadSettingAsyncTask has empty context!");
                return false;
            }

            SettingsManager settingsMgr = SettingsManager.getInstance();
            final String requestUrl = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_GET_PRELOAD_SETTING);
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, requestUrl);
            request.addParams("pl", "android");
            request.addParams("appId", AppInfo.getAppId(context));
            request.addParams("sdkv", DeviceTracking.getInstance().getVersion());
            request.addParams("pkg", context.getPackageName());
            request.addParams("adid", DeviceHelper.getAdvertiseID(context));
            request.addParams("zdId", deviceId);

            try {
                JSONObject object = request.getJSON();
                int errorCode = object.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = object.getJSONObject("data");
                    if (data == null || !data.has("setting")) {
                        if (callback != null)
                            callback.onFailed(errorCode, "");
                    } else {
                        data = data.getJSONObject("setting");
                        //Log.d("GET SETTINGS" + data.toString());
                        if(data.has("model_preload")) {
                            JSONArray modelPreloadArray = data.getJSONArray("model_preload");
                            settingsMgr.setModelPreloadSetting(context, modelPreloadArray.toString());
                        }

                        if(data.has("brand_preload")) {
                            JSONArray brandPreloadArray = data.getJSONArray("brand_preload");
                            settingsMgr.setBrandPreloadSetting(context, brandPreloadArray.toString());
                        }

                        if(data.has("preload_default")) {
                            JSONArray preloadDefaultArray = data.getJSONArray("preload_default");
                            settingsMgr.setPreloadDefaultSetting(context, preloadDefaultArray.toString());
                        }

                        if (data.has("expiredTime")) {
                            long expiredTime = data.getLong("expiredTime");
                            settingsMgr.saveExpiredTimePreloadSetting(context, expiredTime + System.currentTimeMillis());
                        }

                        if (data.has("token_resubmit_age")) {
                            int interval = data.getInt("token_resubmit_age");
                            settingsMgr.saveResubmitIntervalPreloadSetting(context, interval);
                        }
                    }
                } else {
                    if (callback != null)
                        callback.onFailed(errorCode, "");
                }
            } catch (Exception ex) {
                if (callback != null)
                    callback.onFailed(-108, "Exception error " + ex.getMessage());
            }
        } catch (Exception ex) {
            if (callback != null)
                callback.onFailed(-1, "Exception error " + ex.getMessage());
        }
        if (callback != null)
            callback.onSuccess();
        return true;
    }

}
