package com.zing.zalo.zalosdk.core.helper;

import java.net.URLEncoder;
import java.security.MessageDigest;

import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.log.Log;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Base64;

public class AppInfo {
    private String appId;
    private String facebookAppId;
	String versionName;
	int versionCode;
	String packageName;
	String appName;
	private static String applicationHashKey;
	String firstInstallDate;
    String installDate;
    String lastUpdateDate;
    String installerPackageName;
    private static String firstRunDate;
    String preloadChannel = "";
    private boolean isAutoTrackingOpenApp;

    private static AppInfo __instance;
    public static synchronized AppInfo getInstance(Context ctx) {
        if(__instance == null) {
            __instance = new AppInfo(ctx);
        }

        return __instance;
    }

    static synchronized void reset() {
        __instance = null;
    }

    private AppInfo(Context ctx) {
        extractBasicAppInfo(ctx);
    }

    public static String getAppId(Context ctx) {
        return getInstance(ctx).appId;
    }

    public static Long getAppIdLong(Context ctx) {
        try {
            return Long.parseLong(getInstance(ctx).appId);
        } catch (Exception ex) {
            return 0L;
        }
    }

    public static String getFacebookAppId(Context ctx) {
        return getInstance(ctx).facebookAppId;
    }

	public static String getVersionName(Context ctx) {
        return getInstance(ctx).versionName;
	}
	
	public static int getVersionCode(Context ctx) {
        return getInstance(ctx).versionCode;
	}
	
	public static String getPackageName(Context ctx) {
        return getInstance(ctx).packageName;
	}

	public static String getAppName(Context ctx) {
        return getInstance(ctx).appName;
	}

	public static String getFirstInstallDate(Context ctx) {
        return getInstance(ctx).firstInstallDate;
    }

    public static String getInstallDate(Context ctx) {
        return getInstance(ctx).installDate;
    }

    public static String getLastUpdateDate(Context ctx) {
        return getInstance(ctx).lastUpdateDate;
    }

    public static String getInstallerPackageName(Context ctx) {
        return getInstance(ctx).installerPackageName;
    }

    public static String getPreloadChannel(Context ctx) {
        return getInstance(ctx).preloadChannel;
    }

	public static String getApplicationHashKey(Context ctx) {
		if(applicationHashKey != null) return applicationHashKey;
		
		try {
			PackageInfo info = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), PackageManager.GET_SIGNATURES);
			for (Signature signature : info.signatures) {
				MessageDigest md = MessageDigest.getInstance("SHA");
				md.update(signature.toByteArray());
				applicationHashKey = Base64.encodeToString(md.digest(), Base64.DEFAULT).trim();
			}
		} catch (Exception e) {
			Log.e("getApplicationHashKey",e);
		}
		return applicationHashKey;
	}

	public static String getFirstRunDate(Context ctx) {
        if(firstRunDate != null) return firstRunDate;

        SharedPreferences pref = ctx.getSharedPreferences("zacPref", 0);
        firstRunDate = pref.getString("first_run_date", null);
        if(firstRunDate == null) {
            firstRunDate = String.valueOf(System.currentTimeMillis());
            SharedPreferences.Editor editor = pref.edit();
            editor.putString("first_run_date", firstRunDate);
            editor.apply();
        }

        return firstRunDate;
    }

    public static boolean isAutoTrackingOpenApp(Context ctx) {
        return getInstance(ctx).isAutoTrackingOpenApp;
    }

	private void extractBasicAppInfo(Context ctx) {
	    try {
            PackageManager pm = ctx.getPackageManager();
            packageName = ctx.getPackageName();
            PackageInfo pInfo = pm.getPackageInfo(packageName, PackageManager.GET_PERMISSIONS);
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, PackageManager.GET_META_DATA);
            versionName = pInfo.versionName;
            versionCode = pInfo.versionCode;
            appName = URLEncoder.encode(String.valueOf(pInfo.applicationInfo.loadLabel(pm)), "UTF-8");;
            installerPackageName = pm.getInstallerPackageName(packageName);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
                installDate = String.valueOf(pInfo.firstInstallTime);
                firstInstallDate = String.valueOf(pInfo.firstInstallTime);
                lastUpdateDate = String.valueOf(pInfo.lastUpdateTime);
            } else {
                installDate = "";
                firstInstallDate = "";
                lastUpdateDate = "";
            }

            Bundle bundle = appInfo.metaData;
            appId = getStringValue(bundle, "com.zing.zalo.zalosdk.appID");
            if(appId == null || appId.trim().length() == 0) {
                appId = getStringValue(bundle, "appID");
            }

            isAutoTrackingOpenApp = getBooleanValue(bundle, "com.zing.zalosdk.configAutoTrackingActivity");
            preloadChannel = getStringValue(bundle, "com.zalo.sdk.preloadChannel");
            facebookAppId = getStringValue(bundle, "com.facebook.sdk.ApplicationId");

        } catch(Exception ex) {
            Log.e("extractBasicAppInfo",ex);
        }
	}

	private String getStringValue(Bundle bundle, String key) {
        String result = null;
        try {
            if(bundle.containsKey(key)) {
                result = bundle.getString(key);
            }
        } catch (Exception ex) {
            Log.v(ex.toString());
        }

        return result == null ? "" : result;
    }

    private boolean getBooleanValue(Bundle bundle, String key) {
        try {
            if(bundle.containsKey(key)) {
                return bundle.getBoolean(key);
            }
        } catch (Exception ex) {
            Log.v(ex.toString());
        }

        return false;
    }

	public static void launchMarketApp(Context context, String targetPackage){
		try {
			Intent intent = new Intent(Intent.ACTION_VIEW);
		    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		    intent.setData(Uri.parse("market://details?id="+targetPackage));
		    context.startActivity(intent);	
		}catch (ActivityNotFoundException e) {
			Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id="+targetPackage));
		    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		    context.startActivity(intent);
		}	
	}
	
	public static boolean isPackageExists(Context context, String targetPackage) {
		PackageManager pm = context.getPackageManager();
		try {
			pm.getPackageInfo(targetPackage,
					PackageManager.GET_META_DATA);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public static String getReferrer(Context context) {
	    try {
            return context.getSharedPreferences("zacCookie", 0).getString("referrer", "");
        } catch(Exception ex) {
	        return "";
        }
    }
}
