package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;

public class ZPermissionManager {
	public static boolean isPermissionGranted(Context context, String permission){
		if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1)  {
			try {
				int permissionCheck = context.checkSelfPermission( permission);
				if (permissionCheck == PackageManager.PERMISSION_GRANTED) {
					return true;
				}
			} catch (Exception ex) {
				return true;
			}
		} else {//check app permssion for android 5 and low
			try {
				int res = context.checkCallingOrSelfPermission(permission);
				return (res == PackageManager.PERMISSION_GRANTED);
			}catch (Exception ex){
				ex.printStackTrace();
			}
		}
		return false;
	}
}
