package com.zing.zalo.zalosdk.core;

import android.content.Context;

import com.zing.zalo.devicetrackingsdk.GetPreloadSettingAsyncTask;
import com.zing.zalo.devicetrackingsdk.GetSDKSettingAsyncTask;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.helper.Storage;
import com.zing.zalo.zalosdk.core.helper.Utils;

public class SettingsManager {

    private static final String KEY_LAST_TIME_WAKEUP = "com.zing.zalo.sdk.wakeup.lastimewakeup";
    private static final String KEY_EXPIRE_SETTING = "com.zing.zalo.sdk.wakeup.expiresetting";
    private static final String KEY_WAKEUP_SETTING = "com.zing.zalo.sdk.wakeup.wakeupsetting";
    private static final String KEY_WAKEUP_ENABLE = "com.zing.zalo.sdk.wakeup.wakeupenable";
    private static final String KEY_SETTINGS_WEBVIEW = "com.zing.zalo.sdk.settings.useWebViewForUnloginZalo";
    private static final String KEY_SETTINGS_OUT_APP_LOGIN = "com.zing.zalo.sdk.settings.outapplogin";

    private static final String KEY_PRELOAD_EXPIRE_SETTING = "com.zing.zalo.sdk.settings.preload.expiredsetting";
    private static final String KEY_MODEL_PRELOAD_SETTING ="com.zing.zalo.sdk.settings.preload.model_preload";
    private static final String KEY_BRAND_PRELOAD_SETTING ="com.zing.zalo.sdk.settings.preload.brand_preload";
    private static final String KEY_PRELOAD_DEFAULT_SETTING ="com.zing.zalo.sdk.settings.preload.preload_default";

    private static final String KEY_PRELOAD_RESUBMIT_INTERVAL = "com.zing.zalo.sdk.settings.preload.resubmit_interval";

    private static final SettingsManager settingsManager = new SettingsManager();
    public boolean isInitilzed = false;

    public static SettingsManager getInstance() {
        return settingsManager;
    }

    public synchronized void init(Context _context, String zdId) {
        if (isInitilzed) {
            return;
        }
        isInitilzed = true;
        if (isExpiredSetting(_context)) {
            GetSDKSettingAsyncTask getSDKSettingAsyncTask = new GetSDKSettingAsyncTask(_context, null, zdId);
            getSDKSettingAsyncTask.execute(_context);

            GetPreloadSettingAsyncTask getPreloadSettingAsyncTask = new GetPreloadSettingAsyncTask(_context, null, zdId);
            getPreloadSettingAsyncTask.execute(_context);
        }
    }

    public void saveLastTimeWakeUp(Context context, long value) {
        Utils.saveLong(context, Constant.PREFS_NAME_WAKEUP, KEY_LAST_TIME_WAKEUP, value);
    }

    public long getLastTimeWakeup(Context context) {
        return Utils.getSavedLong(context, Constant.PREFS_NAME_WAKEUP, KEY_LAST_TIME_WAKEUP);
    }

    public void saveExpiredSetting(Context context, long value) {
        Utils.saveLong(context, Constant.PREFS_NAME_WAKEUP, KEY_EXPIRE_SETTING, value);
    }

    public long getExpiredSetting(Context context) {
        return Utils.getSavedLong(context, Constant.PREFS_NAME_WAKEUP, KEY_EXPIRE_SETTING);
    }


    public void saveWakeUpInterval(Context context, long value) {
        Utils.saveLong(context, Constant.PREFS_NAME_WAKEUP, KEY_WAKEUP_SETTING, value);
    }

    public long getWakeUpInterval(Context context) {
        long timeWakeup = Utils.getSavedLong(context, Constant.PREFS_NAME_WAKEUP, KEY_WAKEUP_SETTING);
        if(timeWakeup <= 0){
            timeWakeup = 600000;
        }
        return timeWakeup;
    }

    public void saveWakeUpSetting(Context context, boolean isEnable) {
        Utils.saveBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_WAKEUP_ENABLE, isEnable);
    }

    public boolean getWakeupSetting(Context context) {
        return Utils.getSavedBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_WAKEUP_ENABLE);
    }

    public boolean isUseWebViewUnLoginZalo(Context context) {
        return Storage.getBoolean(context, KEY_SETTINGS_WEBVIEW);
    }

    public boolean isLoginViaBrowser(Context context) {
        return Utils.getSavedBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_SETTINGS_OUT_APP_LOGIN);
    }

    public void setLoginViaBrowser(Context context, boolean isEnable) {
        Utils.saveBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_SETTINGS_OUT_APP_LOGIN, isEnable);
    }

    public void setUseWebViewUnLoginZalo(Context context, boolean enable) {
        Storage.setBoolean(context, KEY_SETTINGS_WEBVIEW, enable);
    }

    public String getModelPreloadSetting(Context context) {
        return Utils.getSavedString(context, Constant.PREFS_NAME_PRELOAD, KEY_MODEL_PRELOAD_SETTING);
    }

    public void setModelPreloadSetting(Context context, String value) {
        Utils.saveString(context, Constant.PREFS_NAME_PRELOAD, KEY_MODEL_PRELOAD_SETTING, value);
    }

    public String getBrandPreloadSetting(Context context) {
        return Utils.getSavedString(context, Constant.PREFS_NAME_PRELOAD, KEY_BRAND_PRELOAD_SETTING);
    }

    public void setBrandPreloadSetting(Context context, String value) {
        Utils.saveString(context, Constant.PREFS_NAME_PRELOAD, KEY_BRAND_PRELOAD_SETTING, value);
    }


    public String getPreloadDefaultSetting(Context context) {
        return Utils.getSavedString(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_DEFAULT_SETTING);
    }

    public void setPreloadDefaultSetting(Context context, String value) {
        Utils.saveString(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_DEFAULT_SETTING, value);
    }

    public void saveExpiredTimePreloadSetting(Context context, long value) {
        Utils.saveLong(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_EXPIRE_SETTING, value);
    }

    public long getExpiredTimePreloadSetting(Context context) {
        return Utils.getSavedLong(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_EXPIRE_SETTING);
    }

    public void saveResubmitIntervalPreloadSetting(Context context, int value) {
        Utils.saveInt(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_RESUBMIT_INTERVAL, value);
    }

    public int getResubmitIntervalPreloadSetting(Context context) {
        return Utils.getSavedInt(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD_RESUBMIT_INTERVAL);
    }

    public boolean isExpiredPreloadSetting(Context context) {
        long expiredTime = getExpiredTimePreloadSetting(context);
        return System.currentTimeMillis() > expiredTime;
    }

    public boolean isExpiredSetting(Context context) {
        long expiredTime = getExpiredSetting(context);
        return System.currentTimeMillis() > expiredTime;
    }
}
