package com.zing.zalo.devicetrackingsdk.model;

import android.content.Context;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PreloadInfo {
    public String preload;
    public String error;
    public Context context;

    public PreloadInfo(Context context) {
        this.context = context;
    }

    public PreloadInfo(Context context, String preload, String error) {
        this.context = context;
        this.preload = preload;
        this.error = error;
    }

    public PreloadInfo(String preload, String error) {
        this.preload = preload;
        this.error = error;
    }


    public boolean isPreloaded() {
        boolean isFilePreload = (preload != null && preload.trim().length() > 0) || (this.error != null && this.error.trim().length() > 0);
        return isFilePreload || isPreloadWithNewCondition();
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jsonPreload = new JSONObject();

        try {
            jsonPreload.put("preload", preload);
            jsonPreload.put("error", error);
            jsonPreload.put("isPreload", isPreloaded());
        } catch (JSONException e) {
            Log.e(PreloadInfo.class.getSimpleName(),e);
        }

        return jsonPreload;
    }


    private boolean isPreloadWithNewCondition() {
        try {
            String listOfBrandPreload = SettingsManager.getInstance().getBrandPreloadSetting(context);
            String listOfModelPreload = SettingsManager.getInstance().getModelPreloadSetting(context);
            String listOfPreloadDefault = SettingsManager.getInstance().getPreloadDefaultSetting(context);
            String preloadDefault = AppInfo.getPreloadChannel(context).toLowerCase();

            boolean isBrandPreload = checkingConditionInJsonArray(DeviceHelper.getBrand().toLowerCase(), listOfBrandPreload);
            boolean isModelPreload = checkingConditionInJsonArray(DeviceHelper.getModel().toLowerCase(), listOfModelPreload);
            boolean isPreloadDefault = checkingConditionInJsonArray(preloadDefault, listOfPreloadDefault);

            boolean isApkPreload = isBrandPreload && (isModelPreload || isPreloadDefault);

            if (isApkPreload) {
                preload = "preload_apk";
            }
            return isApkPreload;
        }catch (Exception ex){
            return false;
        }
    }

    private boolean checkingConditionInJsonArray(String value, String stringJsonArray) {
        try {
            JSONArray dataJsonArray = new JSONArray(stringJsonArray);

            for (int i = 0; i < dataJsonArray.length(); i++) {
                String data = dataJsonArray.optString(i);
                if (value.contains(data)) {
                    return true;
                }
            }
        } catch (JSONException e) {
//            Log.e(PreloadInfo.class.getSimpleName(),e);
        }
        return false;
    }

}

