package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;

/**
 * Created by CPU10329-local on 7/24/2017.
 */

public class OpenAPIActivity extends Activity{

    LoginListener listener;
    // Login callback
    private class LoginListener extends OAuthCompleteListener {
        String shareTo;
        boolean autoBack;
        public LoginListener(String shareTo, boolean _autoBack) {
            this.shareTo = shareTo;
            this.autoBack = _autoBack;
        }

        @Override
        public void onAuthenError(ErrorResponse response) {
            super.onAuthenError(response);
            int errorCode = response.getErrorCode();
            String message = response.getErrorMsg();

            if(OpenAPIService.getInstance().mCallback != null) {
                ZaloPluginCallback callback = OpenAPIService.getInstance().mCallback.get();
                if (callback != null)
                    callback.onResult(false, errorCode, message, "");
            }
            finish();
        }

        @Override
        public void onGetOAuthComplete(OauthResponse response) {
            super.onGetOAuthComplete(response);
            OpenAPIService op = OpenAPIService.getInstance();
            if(op.mCallback != null) {
                ZaloPluginCallback callback = op.mCallback.get();
                Context context = op.mWeakContext.get();
                if (callback != null && context !=null) {
                    op._shareTo = shareTo;
                    op._autoBack = autoBack;
                    op.doShare(context, op.mFeedOb, callback, op._shareTo, op._autoBack);
                }
            }
            finish();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //login from share feed
        Intent intent = getIntent();
        boolean login_from_share_feed = intent.getBooleanExtra("login_from_share_feed", false);
        String shareTo = intent.getStringExtra("share_to");
        boolean _autoBack = intent.getBooleanExtra("autoBack", false);
        //TODO review code_challenge
        String code_challenge = intent.getStringExtra("code_challenge");
        if (login_from_share_feed) {
            listener = new LoginListener(shareTo, _autoBack);
            ZaloSDK.Instance.authenticateZaloPlugin(this, code_challenge, listener);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult(this, requestCode, resultCode, data);
    }

}
