package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;

import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Map;

/**
 * Interface for query Zalo's Open API
 */
public class OpenAPIService {

    private OauthStorage mStorage = null;
    private static final String ZALO_PARAM_BACK_TO_SOURCE = "backToSource";
    private static final String ZALO_PARAM_POST_FEED = "postFeed";

    private static final String AUTH_MOBILE_ACCESS_TOKEN_PATH = "/v3/mobile/access_token";
    private static final String GRAPH_OA_MESSAGE_PATH = "/v2.0/oa/message";
    private static final String GRAPH_APP_REQUESTS_PATH = "/v2.0/apprequests";
    private static final String GRAPH_ME_FEED_PATH = "/v2.0/me/feed";
    private static final String GRAPH_ME_MESSAGE_PATH = "/v2.0/me/message";
    private static final String GRAPH_ME_FRIENDS_PATH = "/v2.0/me/friends";
    private static final String GRAPH_ME_INVITABLE_FRIENDS_PATH = "/v2.0/me/invitable_friends";
    private static final String GRAPH_V2_ME_PATH = "/v2.0/me";

    private static final String AUTH_MOBILE_ACCESS_TOKEN_PATH_V4 = "/v4/access_token";
    private boolean unableShareWebView = false;
    protected WeakReference<ZaloPluginCallback> mCallback;
    protected WeakReference<Context> mWeakContext;
    protected FeedData mFeedOb;
    public String _shareTo = "";
    public boolean _autoBack = false;
    private String tokenShareZalo = "";
    private BroadcastReceiver feedCallbackReceiver;
    private boolean isRegister = false;
    private WeakReference<ZaloPluginCallback> mCallbackZaloClient;
    private static final String UTF8 = "UTF-8";
    private ShareVia shareVia = ShareVia.AppThenWeb;
    private boolean shareMessageChatOnly = false;
    private static OpenAPIService Instance;


    public OpenAPIService() {
        this.mStorage = ZaloSDK.Instance.getOauthStorage();
    }

    /**
     *
     * Deprecated: new OpenAPIService and use it, this method may be removed in next version.
     */
    @Deprecated
    public static OpenAPIService getInstance() {
        if (Instance == null) {
            Instance = new OpenAPIService();
        }
        return Instance;
    }
    
    //--

    private String buildFieldsParam(String[] fields) {
        if (fields != null && fields.length > 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < fields.length - 1; i++) {
                param.append(fields[i]).append(",");
            }
            param.append(fields[fields.length - 1]);
            return param.toString();
        }
        return "";
    }

    /**
     * Get Zalo user's profile
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/thong-tin-nguoi-dung-post-28
     *
     * @param ctx      The context call this method
     * @param callback
     * @param fields   : id, birthday, gender, picture, name ex: {"id", "birthday", "gender", "picture", "name"}
     */
    public void getProfile(Context ctx, String access_token, ZaloOpenAPICallback callback, String[] fields) {
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_V2_ME_PATH));
        request.addParams("fields", buildFieldsParam(fields));
        request.addParams("access_token", access_token);
        new RequestAPITask(ctx, callback).execute(request);
    }

    /**
     * Lấy danh sách tất cả bạn bè của người dùng đã sử dụng ứng dụng
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/danh-sach-ban-be-post-34
     *
     * @param ctx      The context call this method
     * @param position position
     * @param count    count
     * @param callback
     * @param fields   : Hỗ trợ các field: id, name, picture, gender
     */
    public void getFriendListUsedApp(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_FRIENDS_PATH));
        request.addParams("fields", buildFieldsParam(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        request.addParams("access_token", access_token);
        new RequestAPITask(ctx, callback).execute(request);
    }

    /**
     * Lấy danh sách bạn bè chưa sử dụng ứng dụng và có thể nhắn tin mời sử dụng ứng dụng
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/danh-sach-ban-be-post-34
     *
     * @param ctx      The context call this method
     * @param position position
     * @param count    count
     * @param callback
     * @param fields   : Hỗ trợ các field: id, name, picture, gender
     */
    public void getFriendListInvitable(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH,GRAPH_ME_INVITABLE_FRIENDS_PATH ));
        request.addParams("fields", buildFieldsParam(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        request.addParams("access_token", access_token);
        new RequestAPITask(ctx, callback).execute(request);
    }

    //--new API
    private class GetTokenTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {

        Context ctx;
        WeakReference<ZaloOpenAPICallback> mOpenAPICallbackAsync;

        GetTokenTask(Context ctx, WeakReference<ZaloOpenAPICallback> _mOpenAPICallbackAsync) {
            this.ctx = ctx;
            mOpenAPICallbackAsync = _mOpenAPICallbackAsync;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected JSONObject doInBackground(HttpClientRequest... requests) {
            JSONObject accessToken;
            HttpClientRequest request = requests[0];
            accessToken = request.getJSON();

            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":"+ ZaloOAuthResultCode.ERR_CREATE_ACCESS_TOKEN_FAILED+"}");
                } catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                return accessToken;
            }
        }

        @Override
        protected void onPostExecute(JSONObject object) {
            try {
                if (object != null) {
                    if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null)
                        mOpenAPICallbackAsync.get().onResult(object);
                } else {
                    if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null)
                        mOpenAPICallbackAsync.get().onResult(new JSONObject("{\"error\":" + ZaloOAuthResultCode.ERR_UNKNOWN_ERROR + "}"));
                }
            } catch (Exception ex) {
            }
        }
    }

    private class RequestAPITask extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context ctx;
        ZaloOpenAPICallback mOpenAPICallbackNewAPI;
        RequestAPITask(Context ctx, ZaloOpenAPICallback _mOpenAPICallbackNewAPI) {
            this.ctx = ctx;
            mOpenAPICallbackNewAPI = _mOpenAPICallbackNewAPI;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected JSONObject doInBackground(HttpClientRequest... requests) {
            HttpClientRequest request = requests[0];
            return request.getJSON();
        }

        @Override
        protected void onPostExecute(JSONObject object) {
            try {
                if (object != null) {
                    mOpenAPICallbackNewAPI.onResult(object);
                } else {
                    mOpenAPICallbackNewAPI.onResult(new JSONObject("{\"error\":" + ZaloOAuthResultCode.ERR_UNKNOWN_ERROR + "}"));
                }
            }catch (Exception ex){
                ex.printStackTrace();
                mOpenAPICallbackNewAPI.onResult(null);
            }
        }
    }

    //---ZPlugin---

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.shareVia = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.shareMessageChatOnly = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.shareVia;
    }

    public void shareFeed(final Context context, final FeedData feedOb, final ZaloPluginCallback callback) {
        loginThenShare(context, feedOb, callback, "feed", false);
    }

    public void shareMessage(final Context context, final FeedData feedOb, final ZaloPluginCallback callback) {
        loginThenShare(context, feedOb, callback, "message", false);
    }

    public void share(final Context context, final FeedData feedOb, final ZaloPluginCallback callback) {
        loginThenShare(context, feedOb, callback, null, false);
    }


    public void shareFeed(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, boolean autoBack) {
        loginThenShare(context, feedOb, callback, "feed", autoBack);
    }

    public void shareMessage(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, boolean autoBack) {
        loginThenShare(context, feedOb, callback, "message", autoBack);
    }

    public void share(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, boolean autoBack) {
        loginThenShare(context, feedOb, callback, null, autoBack);
    }


    private void showOptionShare(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final boolean autoBack) {
        CharSequence colors[] = new CharSequence[]{"Gửi tin nhắn Zalo", "Đăng lên Zalo"};

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle("Chọn");
        builder.setItems(colors, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    doShare(context, feedOb, callback, "message", autoBack);
                } else {
                    doShare(context, feedOb, callback, "feed", autoBack);
                }
            }
        });
        builder.show();
    }

    private void shareWebView(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, final boolean autoBack) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), UTF8)).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), UTF8)).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), UTF8)).append("&");
            sb.append("app_id=").append(String.valueOf((ZaloSDK.Instance.getAppID()))).append("&");
            if (!TextUtils.isEmpty(shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
//            sb.append("code=").append(URLEncoder.encode(mStorage.getZaloPluginOAuthCode(), UTF8)).append("&");

            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String version = pInfo.versionName;
            sb.append("app_version=").append(version).append("&");
            sb.append("sdk_version=").append(String.valueOf((ZaloSDK.Instance.getVersion()))).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");

            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), UTF8)).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), UTF8)).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), UTF8)).append("&");

            if (feedOb.getLinkThumb() != null) {
                int length = feedOb.getLinkThumb().length;
                for (int i = 0; i < length; i++) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(feedOb.getLinkThumb()[i], UTF8)).append("&");
                }
            }

            //
            if (feedOb.getParams() != null)
                for (Map.Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    // do stuff
                    sb.append(key + "=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                }
            Bundle bundle = new Bundle();
            bundle.putString(WebDialog.EXTRA_QUERY, sb.toString());
            bundle.putString(WebDialog.EXTRA_REQUEST_BODY, extraBody.toString());
            //TODO comment get oauthcode
//            bundle.putString(WebDialog.EXTRA_OAUTH_CODE, mStorage.getZaloPluginOAuthCode());

            final WebDialog feedDialog = new WebDialog.FeedDialogBuilder(context, bundle).build();
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback() {

                @Override
                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();

                    if (errorCode == -10) {
                        unableShareWebView = true;
                        doShare(context, feedOb, callback, shareTo, autoBack);
                    } else if (errorCode == -1) {
                        loginZalo(context, feedOb, callback, shareTo, autoBack);
                    } else {
                        unableShareWebView = false;
                        if (callback != null)
                            callback.onResult(arg0, errorCode, arg2, arg3);
                    }
                }
            });
            feedDialog.show();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loginThenShare(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, boolean autoBack) {
        doShare(context, feedOb, callback, shareTo, autoBack);
    }

//    private void loginThenShare(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, boolean autoBack) {
////		Log.i("debuglog", "00000 487 shareTo: " + shareTo);
//        if (ZaloSDK.Instance.isAuthenticate(mStorage.getZaloPluginOAuthCode(), null)) {
////			Log.i("debuglog", "00000 488 shareTo: " + shareTo);
//            doShare(context, feedOb, callback, shareTo, autoBack);
//        } else {
//            if (LoginChannel.ZALO.toString().equalsIgnoreCase(mStorage.getLastestLoginChannel()) &&
//                    ZaloSDK.Instance.isAuthenticate(null)) {
//                mStorage.setZaloPluginOAuthCode(mStorage.getOAuthCode());
//                mStorage.setZaloPluginUserId(mStorage.getZaloId());
//                doShare(context, feedOb, callback, shareTo, autoBack);
//                return;
//            }
//            loginZalo(context, feedOb, callback, shareTo, autoBack);
//        }
//    }

    protected void doShare(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, boolean autoBack) {
        mFeedOb = feedOb;
        _shareTo = shareTo;
        _autoBack = autoBack;
//		Log.i("debuglog", "doshare 508: " + shareTo);
        //share
        if (unableShareWebView) {
            shareZalo(context, feedOb, callback, shareTo, autoBack);
            return;
        }

        if (shareVia == ShareVia.AppThenWeb) {
            if (Utilities.isZaloInstalled(context)) {
                shareZalo(context, feedOb, callback, shareTo, autoBack);
            } else {
                shareWebView(context, feedOb, callback, shareTo, autoBack);
            }
        } else {
            shareWebView(context, feedOb, callback, shareTo, autoBack);
        }
    }

    private void shareZalo(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, boolean autoBack) {
        if (TextUtils.isEmpty(shareTo)) {
            showOptionShare(context, feedOb, callback, autoBack);
        } else {
            Intent intent = getShareIntentZalo(context, feedOb, shareTo, autoBack);
            boolean ableCalled = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
            if (ableCalled) {
                registerBroadCast(context);
                mCallbackZaloClient = new WeakReference<ZaloPluginCallback>(callback);
                context.startActivity(intent);
            } else {
                Utilities.invokeMarketApp(context, Constant.ZALO_PACKAGE_NAME);
            }
        }
    }

    private Intent newIntent(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent newShareFeedLoginIntent(Context context, String shareTo, boolean _autoBack) {
        Intent intent = newIntent(context);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        intent.putExtra("autoBack", _autoBack);
        return intent;
    }

    private void loginZalo(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean _autoBack) {
        mFeedOb = feedOb;
        mCallback = new WeakReference<ZaloPluginCallback>(callback);
        mWeakContext = new WeakReference<Context>(context);
        Intent intent = newShareFeedLoginIntent(context, shareTo, _autoBack);
        context.startActivity(intent);
    }

    private Intent getShareIntentZalo(Context context, FeedData feedOb, final String shareTo, boolean autoBack) {
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.setType("text/plain");
        intent.setComponent(new ComponentName(Constant.ZALO_PACKAGE_NAME, "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra(Intent.EXTRA_SUBJECT, feedOb.getMsg());
        intent.putExtra(Intent.EXTRA_TEXT, feedOb.getLink());
        tokenShareZalo = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", tokenShareZalo);
        if (!TextUtils.isEmpty(shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra(ZALO_PARAM_POST_FEED, true);
            } else if (shareTo.equals("message") && shareMessageChatOnly) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (autoBack) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra(ZALO_PARAM_BACK_TO_SOURCE, true);
        return intent;
    }

    private void registerBroadCast(Context mContext) {
        if (Utilities.isZaloSupportCallBack(mContext)) {
            if (!isRegister) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                feedCallbackReceiver = new BroadcastReceiver() {
                    @Override
                    public void onReceive(Context context, Intent intent) {
                        String json = intent.getExtras().getString("result");
                        JSONObject jOb = null;
                        try {
                            jOb = new JSONObject(json);
                            int errorCode = 0;
                            boolean isSucc = false;
                            String token = null;
                            if (jOb != null && jOb.has("token")) {
                                token = jOb.getString("token");
                                if (token != null && token.equals(tokenShareZalo)) {
                                    errorCode = jOb.getInt("error_code");
                                    unRegisterReceiver(context);//unregister after received callback
                                    if (mCallbackZaloClient != null) {
                                        ZaloPluginCallback callback = mCallbackZaloClient.get();
                                        if (errorCode == 0) {
                                            isSucc = true;
                                        }
                                        if (callback != null) {
                                            callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                        }
                                    }
                                }
                            }
                        } catch (Exception ex) {

                        }
                    }
                };
                mContext.registerReceiver(feedCallbackReceiver, filter);
                isRegister = true;
//				Log.i("debuglog", "register broadcast receiver=====");
            }
        } else {
            if (mCallbackZaloClient != null) {
                ZaloPluginCallback callback = mCallbackZaloClient.get();
                if (callback != null) {
                    callback.onResult(true, 0, null, null);
                }
            }
        }
    }

    private void unRegisterReceiver(Context mContext) {
        if (feedCallbackReceiver != null) {
            mContext.unregisterReceiver(feedCallbackReceiver);
            isRegister = false;
//			Log.i("debuglog", "unregister ----- broadcast receiver=====");
        }
    }

    /**
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/moi-su-dung-ung-dung-post-41
     *
     * @param ctx      Context
     * @param friendId ex: {"friend-id1", "friend-id2", "friend-id3"}
     * @param message  String
     * @param callback ZaloOpenAPICallback
     */
    public void inviteFriendUseApp(Context ctx, String access_token, String[] friendId, String message, ZaloOpenAPICallback callback){
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_APP_REQUESTS_PATH));
        request.addParams("to", buildFieldsParam(friendId));
        request.addParams("message", message);
        request.addParams("access_token", access_token);
        new RequestAPITask(ctx, callback).execute(request);
    }

    /**
     * Post a feed to wall
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/dang-bai-viet-post-39
     *
     * @param context  Context
     * @param access_token     token for access
     * @param link     String url link
     * @param msg      String msg
     * @param callback ZaloOpenAPICallback
     */
    public void postToWall(Context context, String access_token, String link, String msg, ZaloOpenAPICallback callback)
    {
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_FEED_PATH));
        request.addParams("link", link);
        request.addParams("message", msg);
        request.addParams("access_token", access_token);
        new RequestAPITask(context, callback).execute(request);
    }

    /**
     * Send message to friend
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/goi-tin-nhan-toi-ban-be-post-1183
     *
     * @param context  Context
     * @param friendId Friend ID
     * @param msg      String content message
     * @param link     Link
     * @param callback ZaloOpenAPICallback
     */
    public void sendMsgToFriend(Context context, String access_token, String friendId, String msg, String link, ZaloOpenAPICallback callback){
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_MESSAGE_PATH));
        request.addParams("to", friendId);
        request.addParams("message", msg);
        request.addParams("link", link);
        request.addParams("access_token", access_token);
        new RequestAPITask(context, callback).execute(request);
    }

    /**
     * Gởi tin nhắn đến người dùng của bạn qua Official Account được liên kết với ứng dụng. Các tin nhắn phải được gửi theo các mẫu đã được định nghĩa trước. Ứng dụng bên thứ 3 cần liên hệ oa@zaloapp.com  để tạo các mẫu này.
     * https://developers.zalo.me/docs/api/open-api/tai-lieu/goi-tin-nhan-tu-official-account-post-1174
     *
     * @param context      Context
     * @param templateid   Id của mẫu cần gử
     * @param templatedata Chứa các giá trị sẽ được thay vào mẫu để tạo thành một tin nhắn dạng text. Ví dụ: {“DAY”:”20″,”TIME_24HR”:”17h”}
     * @param callback     ZaloOpenAPICallback
     */
    public void broadcastViaOfficalAccount(Context context, String access_token, String templateid, String templatedata, ZaloOpenAPICallback callback){
        validateField(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_OA_MESSAGE_PATH));
        request.addParams("templateid", templateid);
        request.addParams("templatedata", templatedata);
        request.addParams("access_token", access_token);
        new RequestAPITask(context, callback).execute(request);
    }

    public void getAccessTokenByOAuthCode(Context context, String oauthCode, String codeVerifier, ZaloOpenAPICallback callback) {
        validateField(oauthCode, "oauthCode must be set.");
        validateField(codeVerifier, "codeVerifier must be set.");
        HttpClientRequest request = new HttpClientRequest(
            Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ACCESS_TOKEN_PATH_V4));

        request.addParams("code", oauthCode);
        request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
        request.addParams("grant_type", ZaloSDK.Instance.getGrantType(true));
        request.addParams("code_verifier", codeVerifier);
        new GetTokenTask(context, new WeakReference<>(callback)).execute(request);
    }

    public void getAccessTokenByRefreshToken(Context context, String refresh_token, ZaloOpenAPICallback callback) {
        validateField(refresh_token, "refresh_token must be set.");
        HttpClientRequest request = new HttpClientRequest(
            Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ACCESS_TOKEN_PATH_V4));

        request.addParams("refresh_token", refresh_token);
        request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
        request.addParams("grant_type", ZaloSDK.Instance.getGrantType(false));
        new GetTokenTask(context, new WeakReference<>(callback)).execute(request);
    }

    private void validateField(String value, String msg) {
        if (TextUtils.isEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
    }
}
