package me.zalo.startuphelper;

import android.content.Context;
import android.os.AsyncTask;

import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.type.EventType;

import java.util.HashMap;
import java.util.Map;

public class SubmitOpenAppEventAsyncTask extends AsyncTask<Context, Void, Void> {
    private final Map<String, String> extra;

    SubmitOpenAppEventAsyncTask(Map<String, String> extra) {
        this.extra = extra;
    }
    @Override
    protected Void doInBackground(Context... contexts) {
        Context context = contexts[0];
        Map<String, String> params = new HashMap<>();
        PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo(context);

        if(preloadInfo != null) {
            params.put("preloadDefault", AppInfo.getPreloadChannel(context));
            params.put("preload", preloadInfo.preload);
            if(!preloadInfo.isPreloaded()) {
                params.put("preloadFailed", preloadInfo.error);
            }
        }

        String listDeviceId = Utils.loadListDeviceIDWakeUp(context);
        params.put("wakeupInfo", listDeviceId);

        if(extra != null) {
            params.putAll(extra);
        }

        ZingAnalyticsManager.getInstance().addEvent(EventType.OPEN_APP, params);
        ZingAnalyticsManager.getInstance().dispatchEvents();
        return null;
    }
}
