package me.zalo.startuphelper;

import static me.zalo.startuphelper.StartupHelperUtil.startupStep;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;

import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.type.EventType;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ThuanNM on 1/3/2019.
 * StartupHelper
 */
class StartUpTracker {

    private static final String KEY_FIREBASE_TOKEN = "com.zing.zalo.sdk.wakeup.firebasetoken";
    private static final String KEY_CHECK_SUBMIT_TOKEN = "com.zing.zalo.sdk.wakeup.isSubmitFirebaseToken";

    private static final String KEY_TIME_SUBMIT_TOKEN = "com.zing.zalo.sdk.wakeup.timeSubmitFirebaseToken";

    private static final String KEY_STATUS_NOTI_PERMISSION = "com.zing.zalo.sdk.wakeup.statusNotiPermission";

    private static final String KEY_STATUS_RESTRICT_MODE = "com.zing.zalo.sdk.wakeup.statusRestrictMode";
    public static final String WK_PGK_NAME = "wk_pgk_name";
    public static final String WK_NOTIF = "wk_notif";
    public static final String WK_SOURCE = "wk_source";
    public static final String WK_URL = "wk_url";
    private static final String WK_GLOBAL_ID = "wk_globalid";
    public static final String WK_OPEN_PS = "wk_open_ps";

    private String wakerPkgName;
    private String wakerDeviceId;
    private boolean isNotifOpen = false;
    private boolean isWakeUp = false;
    private boolean isOpenApp = false;
    private boolean isSubmittingToken = false;
    private Context context;
    private static long RESUBMIT_TIME = 2_592_000_000L;
    private static long ONE_DAY_MILIS = 86_400_000L;
    StartUpTracker(Context context) {
        this.context = context.getApplicationContext();
        tryToInitZaloSDK();
    }

    private void tryToInitZaloSDK() {
        try {
            Application app = (Application) context.getApplicationContext();
            if(!Utils.initZaloSDK(app)) {
                ZingAnalyticsManager.getInstance().init(app);
            }
        } catch(Exception ex) {
            Log.v(ex.getMessage());
        }
    }

    void onAppOpenedFromNotification(Intent intent) {
        if(intent == null || !intent.hasExtra(WK_SOURCE)) return;

        String sourceNotif = intent.getStringExtra(WK_SOURCE);
        if (TextUtils.isEmpty(sourceNotif)) {
            return;
        }

        //add event
        Map<String, String> params = new HashMap<>();
        params.put("sourceFrom", sourceNotif);
        params.put("wakeupInfo", Utils.loadListDeviceIDWakeUp(context));

        if (intent.hasExtra(WK_GLOBAL_ID)) {
            String globalIDReceived = intent.getStringExtra(WK_GLOBAL_ID);
            params.put("sourceGid", globalIDReceived);
        }

        ZingAnalyticsManager.getInstance().addEvent(EventType.OPEN_APP_BY_NOTIFICATION, params);
        ZingAnalyticsManager.getInstance().dispatchEvents();

        isNotifOpen = true;
        wakerPkgName = sourceNotif;
        startupStep = StartupHelperUtil.StartupStep.OPEN_APP_SUBMIT_TOKEN;
        String token = getSavedFirebaseToken();
        boolean resubmit = isReSubmitToken();
        if (/*!TextUtils.isEmpty(token) &&*/ isFirstTimeSubmit() || resubmit || !isFirebaseTokenSubmitted()) {
            setFirebaseTokenSubmitted(false);
            submitFirebaseToken(token, resubmit);
        }
    }


    void onAppOpened(Map<String, String> extra) {
        isOpenApp = true;
        wakerPkgName = "";
        SubmitOpenAppEventAsyncTask task = new SubmitOpenAppEventAsyncTask(extra);
        task.execute(context);

        String token = getSavedFirebaseToken();
        startupStep = StartupHelperUtil.StartupStep.OPEN_APP_SUBMIT_TOKEN;
        boolean resubmit = isReSubmitToken();
        if (/*!TextUtils.isEmpty(token) &&*/ isFirstTimeSubmit() || resubmit || !isFirebaseTokenSubmitted()) {
            setFirebaseTokenSubmitted(false);
            submitFirebaseToken(token, resubmit);
        }
    }

    //được wakeup từ app khác
    void onWakeUp(String fromPkg, String fromDeviceId) {
        isWakeUp = true;
        wakerPkgName = fromPkg;
        wakerDeviceId = fromDeviceId;
        saveListDeviceIdWakeUp(fromDeviceId, System.currentTimeMillis(), fromPkg);

        String token = getSavedFirebaseToken();
        startupStep = StartupHelperUtil.StartupStep.WAKEUP_APP_SUBMIT_TOKEN;
        boolean resubmit = isReSubmitToken();
        if (/*!TextUtils.isEmpty(token) &&*/ isFirstTimeSubmit() || resubmit || !isFirebaseTokenSubmitted()) {
            setFirebaseTokenSubmitted(false);
            submitFirebaseToken(token, resubmit);
        }
    }

    boolean isFirstTimeSubmit() {
        long lastTimeFirebaseSubmit = getLastTimeFirebaseSubmitted();
        int lastStatusRestrictMode = getStatusRestrictMode();
        int lastStatusNotiPermission = getStatusNotiPermission();
        String msg = "isFirst:(" + lastTimeFirebaseSubmit + "," + lastStatusNotiPermission +
                "," + lastStatusRestrictMode +")";
        //Log.d(msg);
        // Submit neu la gia tri moi lay ra lan dau trong cache
        return lastTimeFirebaseSubmit == -1 || lastStatusNotiPermission == -1 || lastStatusRestrictMode == -1;
    }

    private boolean isReSubmitToken() {
        long lastTimeFirebaseSubmit = getLastTimeFirebaseSubmitted();
        int lastStatusRestrictMode = getStatusRestrictMode();
        int lastStatusNotiPermission = getStatusNotiPermission();

        if (isFirstTimeSubmit()) {
            return false;
        }

        // Default 30 days
        long interval = RESUBMIT_TIME;
        int days = SettingsManager.getInstance().getResubmitIntervalPreloadSetting(context);
        if (days > 0) {
            interval = days * ONE_DAY_MILIS;
        }
        // Submit neu qua thoi gian RESUBMIT_TIME
        if (lastTimeFirebaseSubmit > 0 && lastTimeFirebaseSubmit + interval < System.currentTimeMillis())
            return true;

        // Submit neu gia tri bi thay doi
        int currentStatusRestrictMode = StartupHelperUtil.getStatusRestrictMode(context) ? 1 : 0;
        int currentStatusNotiPermission = StartupHelperUtil.getStatusNotiPermission(context) ? 1 : 0;

        String msg = "lR:(" +lastStatusRestrictMode +","+ currentStatusRestrictMode
                + ") lN:(" + lastStatusNotiPermission+","+currentStatusNotiPermission+")";
        //Log.d(msg);
        return lastStatusRestrictMode != currentStatusRestrictMode
                || lastStatusNotiPermission != currentStatusNotiPermission;
    }
    /**
     * Submit FirebaseToken to server
     *
     * @param firebaseToken firebaseToken
     */
    void setFirebaseToken(String firebaseToken) {
        String oldFirebaseToken = getSavedFirebaseToken();
        if (!firebaseToken.equals(oldFirebaseToken) || !isFirebaseTokenSubmitted()){
            if(!TextUtils.isEmpty(firebaseToken)){
                saveFirebaseToken(firebaseToken);
                setFirebaseTokenSubmitted(false);
            }
            submitFirebaseToken(firebaseToken, false);
        }
        else {
            Log.e("setFirebaseToken", String.format("setFirebaseToken failed: oldToken=%s - newToken=%s - isSubmitted: %s",
                    oldFirebaseToken,firebaseToken,isFirebaseTokenSubmitted()));
        }
    }

    private void submitFirebaseToken(final String token, final boolean resubmit) {
        //final String token = "fEweXge7RO2G90ALxDa14r:APA91bFSoZcbQd9uZEm9Ibr5HTfBi5xklT1VHthu0pVRd8MHp3K8IL-YJwneYwFeMrEB9Lt50lCinglDKHczuJiqlNeTTwLFmnYrQXoB1el2S0DYIqg_IP_053LtfVOTWV9lUFw358fr";
        //Log.d("submitFirebaseToken" + token);
        boolean isSubmitFirebaseBefore = isFirebaseTokenSubmitted();
        if (isSubmitFirebaseBefore || isSubmittingToken){
            return;
        }

        isSubmittingToken = true;

        //get device id
        DeviceTracking.getInstance().getDeviceId(new DeviceTracking.GetInfoListener() {
            @Override
            public void onGetDeviceIdComplete(String deviceId) {
                if (TextUtils.isEmpty(deviceId)) {
                    Log.e("submitFirebaseToken", "submitFirebaseToken: Can't get device id");
                    isSubmittingToken = false;
                    return;
                }

                //get params
                GenerateTrackingParamsAsyncTask task = new GenerateTrackingParamsAsyncTask(wakerDeviceId,
                        new GenerateTrackingParamsAsyncTask.Callback() {
                    @Override
                    public void onCompleted(String params) {
                        //get params completed
                        SubmitFirebaseTokenAsyncTask.Type type = SubmitFirebaseTokenAsyncTask.Type.OPEN_APP;
//                        if (isWakeUp){
//                            type = SubmitFirebaseTokenAsyncTask.Type.WAKE_UP;
//                            StartupHelperUtil.callbackToWaker(context, params, token, wakerPkgName);
//                        } else if (isNotifOpen){
//                            type = SubmitFirebaseTokenAsyncTask.Type.NOTIF;
//                        }
                        //thuannm: 1. NOTIF is highest priority
                        //2. if app open first, wakeup after open_app -> it will be open_app
                        // Example: app1 open -> wakeup app2 -> app2 wakeup app1->app1 must subtmit open_app
                        if (isNotifOpen){
                            type = SubmitFirebaseTokenAsyncTask.Type.NOTIF;
                        } else if (!isOpenApp && isWakeUp){
                            type = SubmitFirebaseTokenAsyncTask.Type.WAKE_UP;
                        }
                        try {
                            JSONObject jsonObject = new JSONObject(params);
                            jsonObject.put("resubmit", resubmit);
                            params = jsonObject.toString();
                        } catch (JSONException e) {
                        }
                        final SubmitParam submitParam = new SubmitParam(type, params, token, wakerPkgName,
                                startupStep, resubmit);
                        //Log.d("DO SUBMIT" + token);
                        //submit token
                        SubmitFirebaseTokenAsyncTask task =
                                new SubmitFirebaseTokenAsyncTask(submitParam, new SubmitFirebaseTokenAsyncTask.Callback() {
                            @Override
                            public void onCompleted(boolean success) {
                                isSubmittingToken = false;
                                //Log.d("DONE SUBMIT " + success);
                                if(!TextUtils.isEmpty(token) && success) {
                                    setFirebaseTokenSubmitted(true);
                                    setLastTimeFirebaseSubmitted(System.currentTimeMillis());
                                    setStatusNotiPermission(StartupHelperUtil.getStatusNotiPermission(context));
                                    setStatusRestrictMode(StartupHelperUtil.getStatusRestrictMode(context));
                                }
                            }
                        });
                        task.execute();
                    }
                });
                task.execute(context);
            }
        });
    }

    void onTerminate() { }

    boolean isOpenAppNotificationData(Map<String, String> stringMap) {
        return stringMap.containsKey(WK_NOTIF) && stringMap.containsKey(WK_SOURCE) &&
                (stringMap.containsKey(WK_URL) || stringMap.containsKey(WK_PGK_NAME));
    }

    private boolean isResolveIntent(Context context, Intent intent){
        PackageManager packageManager = context.getPackageManager();
        return intent != null && intent.resolveActivity(packageManager) != null;
    }

    public void putDeviceIDIntoIntent(Intent intent){
        if (intent != null) {
            String deviceID = DeviceTracking.getInstance().getDeviceId();
            if (!TextUtils.isEmpty(deviceID)){
                intent.putExtra(WK_GLOBAL_ID, deviceID);
            }
        }
    }

    private Intent createIntentOpenPlayStore(Context context, Map<String, String> stringMap){
        Intent intent = null;
        if (stringMap != null && stringMap.containsKey(WK_OPEN_PS)){
            String packageName = stringMap.get(WK_OPEN_PS);
            intent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + packageName));
            boolean isResolveIntent = isResolveIntent(context, intent);
            if (!isResolveIntent) {
                intent = new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + packageName));
            }
            isResolveIntent = isResolveIntent(context, intent);
            if (!isResolveIntent){
                return null;
            }
            if (stringMap.containsKey(WK_PGK_NAME)) {
                if (intent != null) {
                    intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                    intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                    putDeviceIDIntoIntent(intent);
                }
            }else if (stringMap.containsKey(WK_URL)) {
                intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                putDeviceIDIntoIntent(intent);
            }
        }
        return intent;
    }

    Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap) {
        if (stringMap.containsKey(WK_PGK_NAME)) {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(stringMap.get(WK_PGK_NAME));
            if (intent != null) {
                intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                putDeviceIDIntoIntent(intent);
            }
            boolean isResolveIntent = isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
            ZingAnalyticsManager.getInstance().addEvent(EventType.RECEIVE_NOTIFICATION, stringMap);
            ZingAnalyticsManager.getInstance().dispatchEvents();
            if (!isResolveIntent){
                intent = createIntentOpenPlayStore(context, stringMap);
                return intent;
            }
            return intent;
        } else if (stringMap.containsKey(WK_URL)) {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            String uriStr = stringMap.get(WK_URL);
            if(uriStr.contains("?")) {
                uriStr += "&";
            } else {
                uriStr += "?";
            }
            uriStr += WK_SOURCE + "=" + stringMap.get(WK_SOURCE)
                    + "&" + WK_NOTIF + "=" + stringMap.get(WK_NOTIF);

            intent.setData(Uri.parse(uriStr));
            intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
            intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
            putDeviceIDIntoIntent(intent);
            boolean isResolveIntent = isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
            ZingAnalyticsManager.getInstance().addEvent(EventType.RECEIVE_NOTIFICATION, stringMap);
            ZingAnalyticsManager.getInstance().dispatchEvents();
            if (!isResolveIntent){
                intent = createIntentOpenPlayStore(context, stringMap);
                return intent;
            }
            return intent;
        }
        return null;
    }

    boolean isOpenNotificationIntent(Intent intent) {
        return intent != null && intent.hasExtra(WK_SOURCE) && intent.hasExtra(WK_NOTIF);
    }

    Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap, Boolean submitEvent) {
        Intent intent = null;
        boolean isResolveIntent = false;
        if (stringMap.containsKey(WK_PGK_NAME)) {
            intent = context.getPackageManager().getLaunchIntentForPackage(stringMap.get(WK_PGK_NAME));
            if (intent != null) {
                intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                putDeviceIDIntoIntent(intent);
            }
            isResolveIntent = isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
        } else if (stringMap.containsKey(WK_URL)) {
            intent = new Intent(Intent.ACTION_VIEW);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            String uriStr = stringMap.get(WK_URL);
            if(uriStr.contains("?")) {
                uriStr += "&";
            } else {
                uriStr += "?";
            }
            uriStr += WK_SOURCE + "=" + stringMap.get(WK_SOURCE)
                    + "&" + WK_NOTIF + "=" + stringMap.get(WK_NOTIF);

            intent.setData(Uri.parse(uriStr));
            intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
            intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
            putDeviceIDIntoIntent(intent);
            isResolveIntent = isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
        }

        if (submitEvent) {
            ZingAnalyticsManager.getInstance().addEvent(EventType.RECEIVE_NOTIFICATION, stringMap);
            ZingAnalyticsManager.getInstance().dispatchEvents();
        }

        if (!isResolveIntent){
            intent = createIntentOpenPlayStore(context, stringMap);
            return intent;
        }

        return intent;
    }

    private void saveListDeviceIdWakeUp(String deviceIDWakeUp, long timeStamp, String packageName){
        try{
            String str = Utils.loadListDeviceIDWakeUp(context);
            JSONObject oldObj;

            try {
                oldObj = new JSONObject(str);
            } catch (Exception ex) {
                oldObj = new JSONObject();
            }

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("zdid", deviceIDWakeUp);
            jsonObject.put("ts", timeStamp);
            oldObj.put(packageName, jsonObject);
            Utils.saveString(context, Constant.PREFS_NAME_WAKEUP, Constant.KEY_LIST_DEVICEID_WAKE_UP, oldObj.toString());
        }catch (Exception exx){
            exx.printStackTrace();
        }
    }

    //static utils
    private void saveFirebaseToken(String firebaseToken) {
        if(!TextUtils.isEmpty(firebaseToken)) {
            Utils.saveString(context, Constant.PREFS_NAME_WAKEUP, KEY_FIREBASE_TOKEN, firebaseToken);
        }
    }

    private String getSavedFirebaseToken() {
        return Utils.getSavedString(context, Constant.PREFS_NAME_WAKEUP, KEY_FIREBASE_TOKEN);
    }

    private boolean isFirebaseTokenSubmitted(){
        return Utils.getSavedBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_CHECK_SUBMIT_TOKEN);
    }

    private void setFirebaseTokenSubmitted(boolean isSubmit) {
        Utils.saveBoolean(context, Constant.PREFS_NAME_WAKEUP, KEY_CHECK_SUBMIT_TOKEN, isSubmit);
    }

    private long getLastTimeFirebaseSubmitted(){
        return Utils.getSavedLong(context, Constant.PREFS_NAME_WAKEUP, KEY_TIME_SUBMIT_TOKEN);
    }

    private void setLastTimeFirebaseSubmitted(long time) {
        Utils.saveLong(context, Constant.PREFS_NAME_WAKEUP, KEY_TIME_SUBMIT_TOKEN, time);
    }

    public int getStatusNotiPermission(){
        return Build.VERSION.SDK_INT >= 33 ?
                Utils.getSavedInt(context, Constant.PREFS_NAME_WAKEUP, KEY_STATUS_NOTI_PERMISSION) : 1;
    }

    private void setStatusNotiPermission(boolean status) {
        Utils.saveInt(context, Constant.PREFS_NAME_WAKEUP, KEY_STATUS_NOTI_PERMISSION, status ?  1 : 0);
    }

    public int getStatusRestrictMode(){
        return Build.VERSION.SDK_INT >= 28 ?
                Utils.getSavedInt(context, Constant.PREFS_NAME_WAKEUP, KEY_STATUS_RESTRICT_MODE) : 0;
    }

    private void setStatusRestrictMode(boolean status) {
        Utils.saveInt(context, Constant.PREFS_NAME_WAKEUP, KEY_STATUS_RESTRICT_MODE, status ?  1 : 0);
    }
}
