/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.geometry.Acceleration2d;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.MatricesKt;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Twist2d;
import com.acmerobotics.roadrunner.geometry.Twist2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001aH\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001a6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0000\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016\"\u0004\b\u0000\u0010\u0013*\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0017H\u0000\u001a,\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0000\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0018\"\u0004\b\u0000\u0010\u0013*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u001aH\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0012H\u0000\u00a8\u0006\u001c"}, d2={"solveDARE", "Lorg/ejml/simple/SimpleMatrix;", "Ad", "Bd", "Q", "R", "maxIter", "", "epsilon", "", "computeLQRGain", "Lkotlin/Pair;", "discretizeSystem", "A", "B", "dt", "taylorTerms", "concat", "Lcom/acmerobotics/roadrunner/geometry/Twist2dDual;", "Param", "Lcom/acmerobotics/roadrunner/geometry/Twist2d;", "other", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "Lcom/acmerobotics/roadrunner/geometry/Acceleration2d;", "size", "core"})
public final class LQRControllerKt {
    @NotNull
    public static final SimpleMatrix solveDARE(@NotNull SimpleMatrix Ad, @NotNull SimpleMatrix Bd, @NotNull SimpleMatrix Q, @NotNull SimpleMatrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        SimpleMatrix A_K = (SimpleMatrix)Ad.copy();
        SimpleBase simpleBase = R.solve((ConstMatrix)Bd.transpose());
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"solve(...)");
        SimpleMatrix G_K = MatricesKt.times(Bd, (SimpleMatrix)simpleBase);
        SimpleMatrix H_K1 = (SimpleMatrix)Q.copy();
        SimpleMatrix H_K = null;
        int i = 0;
        do {
            SimpleBase simpleBase2 = H_K1.copy();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase2, (String)"copy(...)");
            H_K = (SimpleMatrix)simpleBase2;
            SimpleMatrix W = (SimpleMatrix)SimpleMatrix.identity((int)H_K.getNumRows()).plus((ConstMatrix)MatricesKt.times(G_K, H_K));
            SimpleMatrix v1 = (SimpleMatrix)W.solve((ConstMatrix)A_K);
            SimpleMatrix v2 = (SimpleMatrix)((SimpleMatrix)W.solve((ConstMatrix)G_K.transpose())).transpose();
            SimpleMatrix simpleMatrix = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix);
            Intrinsics.checkNotNull((Object)v2);
            SimpleMatrix simpleMatrix2 = MatricesKt.times(simpleMatrix, v2);
            SimpleBase simpleBase3 = A_K.transpose();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase3, (String)"transpose(...)");
            SimpleBase simpleBase4 = G_K.plus((ConstMatrix)MatricesKt.times(simpleMatrix2, (SimpleMatrix)simpleBase3));
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase4, (String)"plus(...)");
            G_K = (SimpleMatrix)simpleBase4;
            SimpleBase simpleBase5 = v1.transpose();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase5, (String)"transpose(...)");
            SimpleMatrix simpleMatrix3 = MatricesKt.times((SimpleMatrix)simpleBase5, H_K);
            SimpleMatrix simpleMatrix4 = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix4);
            H_K1 = (SimpleMatrix)H_K1.plus((ConstMatrix)MatricesKt.times(simpleMatrix3, simpleMatrix4));
            simpleMatrix4 = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix4);
            Intrinsics.checkNotNull((Object)v1);
            A_K = MatricesKt.times(simpleMatrix4, v1);
        } while (((SimpleMatrix)H_K1.minus((ConstMatrix)H_K)).normF() > epsilon * H_K1.normF() && (maxIter < 0 || i++ < maxIter));
        SimpleMatrix simpleMatrix = H_K1;
        Intrinsics.checkNotNull((Object)simpleMatrix);
        return simpleMatrix;
    }

    public static /* synthetic */ SimpleMatrix solveDARE$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, SimpleMatrix simpleMatrix3, SimpleMatrix simpleMatrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.solveDARE(simpleMatrix, simpleMatrix2, simpleMatrix3, simpleMatrix4, n, d);
    }

    @NotNull
    public static final Pair<SimpleMatrix, SimpleMatrix> computeLQRGain(@NotNull SimpleMatrix Ad, @NotNull SimpleMatrix Bd, @NotNull SimpleMatrix Q, @NotNull SimpleMatrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        SimpleMatrix X = LQRControllerKt.solveDARE(Ad, Bd, Q, R, maxIter, epsilon);
        SimpleBase simpleBase = Bd.transpose();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"transpose(...)");
        SimpleMatrix btx = MatricesKt.times((SimpleMatrix)simpleBase, X);
        SimpleMatrix btxb = MatricesKt.times(btx, Bd);
        SimpleBase simpleBase2 = ((SimpleMatrix)R.plus((ConstMatrix)btxb)).invert();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase2, (String)"invert(...)");
        SimpleMatrix K = MatricesKt.times(MatricesKt.times((SimpleMatrix)simpleBase2, btx), Ad);
        return TuplesKt.to((Object)X, (Object)K);
    }

    public static /* synthetic */ Pair computeLQRGain$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, SimpleMatrix simpleMatrix3, SimpleMatrix simpleMatrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.computeLQRGain(simpleMatrix, simpleMatrix2, simpleMatrix3, simpleMatrix4, n, d);
    }

    @NotNull
    public static final Pair<SimpleMatrix, SimpleMatrix> discretizeSystem(@NotNull SimpleMatrix A, @NotNull SimpleMatrix B, double dt, int taylorTerms) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        int n = A.getNumRows();
        SimpleMatrix Ad = SimpleMatrix.identity((int)n);
        SimpleMatrix simpleMatrix = SimpleMatrix.identity((int)n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"identity(...)");
        SimpleMatrix Bd_integral = MatricesKt.times(simpleMatrix, dt);
        SimpleMatrix APowerDt = MatricesKt.times(A, dt);
        double dtPower = dt;
        double factorial = 1.0;
        int i = 1;
        if (i <= taylorTerms) {
            while (true) {
                Ad = (SimpleMatrix)Ad.plus((ConstMatrix)MatricesKt.times(APowerDt, 1.0 / factorial));
                dtPower *= dt;
                factorial *= (double)(i + 1);
                SimpleBase simpleBase = Bd_integral.plus((ConstMatrix)MatricesKt.times(APowerDt, dt / (double)(i + 1)));
                Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"plus(...)");
                Bd_integral = (SimpleMatrix)simpleBase;
                APowerDt = MatricesKt.times(APowerDt, MatricesKt.times(A, dt));
                factorial *= (double)(i + 1);
                if (i == taylorTerms) break;
                ++i;
            }
        }
        SimpleMatrix Bd = MatricesKt.times(Bd_integral, B);
        return new Pair((Object)Ad, (Object)Bd);
    }

    public static /* synthetic */ Pair discretizeSystem$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, double d, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        return LQRControllerKt.discretizeSystem(simpleMatrix, simpleMatrix2, d, n);
    }

    @NotNull
    public static final <Param> Twist2dDual<Param> concat(@NotNull Twist2d $this$concat, @NotNull Twist2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angle, other.angle};
        return new Twist2dDual<Param>(LQRControllerKt.concat($this$concat.line, other.line), new DualNum(dArray));
    }

    @NotNull
    public static final <Param> Vector2dDual<Param> concat(@NotNull Vector2d $this$concat, @NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.x, other.x};
        DualNum dualNum = new DualNum(dArray);
        dArray = new double[]{$this$concat.y, other.y};
        return new Vector2dDual(dualNum, new DualNum(dArray));
    }

    @NotNull
    public static final <Param> Vector2dDual<Param> concat(@NotNull Vector2dDual<Param> $this$concat, @NotNull Vector2dDual<Param> other) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new Vector2dDual(new DualNum(CollectionsKt.plus((Collection)$this$concat.x.values(), (Iterable)$this$concat.y.values())), new DualNum(CollectionsKt.plus((Collection)$this$concat.x.values(), (Iterable)$this$concat.y.values())));
    }

    @NotNull
    public static final <Param> PoseVelocity2dDual<Param> concat(@NotNull PoseVelocity2d $this$concat, @NotNull Acceleration2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angVel, other.angAcc};
        return new PoseVelocity2dDual<Param>(LQRControllerKt.concat($this$concat.linearVel, other.linearAcc), new DualNum(dArray));
    }

    public static final <Param> int size(@NotNull Twist2dDual<Param> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return $this$size.angle.size();
    }
}

