/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.control.RobotKinematics;
import com.acmerobotics.roadrunner.control.WheelIncrements;
import com.acmerobotics.roadrunner.control.WheelVelocities;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Twist2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0002\u001e\u001fB\u001b\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB#\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010\"\u0004\b\u0000\u0010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/acmerobotics/roadrunner/control/MecanumKinematics;", "Lcom/acmerobotics/roadrunner/control/RobotKinematics;", "Lcom/acmerobotics/roadrunner/control/MecanumKinematics$MecanumWheelIncrements;", "Lcom/acmerobotics/roadrunner/control/WheelVelocities;", "trackWidth", "", "lateralMultiplier", "<init>", "(DD)V", "wheelbase", "(DDD)V", "forward", "Lcom/acmerobotics/roadrunner/geometry/Twist2dDual;", "Param", "w", "inverse", "Lcom/acmerobotics/roadrunner/control/MecanumKinematics$MecanumWheelVelocities;", "t", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "MecanumWheelIncrements", "MecanumWheelVelocities", "core"})
public final class MecanumKinematics
implements RobotKinematics<MecanumWheelIncrements<?>, WheelVelocities<?>> {
    @JvmField
    public final double trackWidth;
    @JvmField
    public final double lateralMultiplier;

    @JvmOverloads
    public MecanumKinematics(double trackWidth, double lateralMultiplier) {
        this.trackWidth = trackWidth;
        this.lateralMultiplier = lateralMultiplier;
    }

    public /* synthetic */ MecanumKinematics(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        this(d, d2);
    }

    public MecanumKinematics(double trackWidth, double wheelbase, double lateralMultiplier) {
        this((trackWidth + wheelbase) / (double)2, lateralMultiplier);
    }

    public /* synthetic */ MecanumKinematics(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        this(d, d2, d3);
    }

    @Override
    @NotNull
    public <Param> Twist2dDual<Param> forward(@NotNull MecanumWheelIncrements<?> w) {
        Intrinsics.checkNotNullParameter(w, (String)"w");
        return new Twist2dDual(new Vector2dDual(w.leftFront.plus(w.leftBack).plus(w.rightBack).plus(w.rightFront).times(0.25), w.leftFront.unaryMinus().plus(w.leftBack).minus(w.rightBack).plus(w.rightFront).times(0.25 / this.lateralMultiplier)), w.leftFront.unaryMinus().minus(w.leftBack).plus(w.rightBack).plus(w.rightFront).times(0.25 / this.trackWidth));
    }

    @Override
    @NotNull
    public <Param> MecanumWheelVelocities<Param> inverse(@NotNull PoseVelocity2dDual<Param> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        return new MecanumWheelVelocities(t.linearVel.x.minus(t.linearVel.y.times(this.lateralMultiplier)).minus(t.angVel.times(this.trackWidth)), t.linearVel.x.plus(t.linearVel.y.times(this.lateralMultiplier)).minus(t.angVel.times(this.trackWidth)), t.linearVel.x.minus(t.linearVel.y.times(this.lateralMultiplier)).plus(t.angVel.times(this.trackWidth)), t.linearVel.x.plus(t.linearVel.y.times(this.lateralMultiplier)).plus(t.angVel.times(this.trackWidth)));
    }

    public final double component1() {
        return this.trackWidth;
    }

    public final double component2() {
        return this.lateralMultiplier;
    }

    @NotNull
    public final MecanumKinematics copy(double trackWidth, double lateralMultiplier) {
        return new MecanumKinematics(trackWidth, lateralMultiplier);
    }

    public static /* synthetic */ MecanumKinematics copy$default(MecanumKinematics mecanumKinematics, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = mecanumKinematics.trackWidth;
        }
        if ((n & 2) != 0) {
            d2 = mecanumKinematics.lateralMultiplier;
        }
        return mecanumKinematics.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "MecanumKinematics(trackWidth=" + this.trackWidth + ", lateralMultiplier=" + this.lateralMultiplier + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.trackWidth);
        result = result * 31 + Double.hashCode(this.lateralMultiplier);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MecanumKinematics)) {
            return false;
        }
        MecanumKinematics mecanumKinematics = (MecanumKinematics)other;
        if (Double.compare(this.trackWidth, mecanumKinematics.trackWidth) != 0) {
            return false;
        }
        return Double.compare(this.lateralMultiplier, mecanumKinematics.lateralMultiplier) == 0;
    }

    @JvmOverloads
    public MecanumKinematics(double trackWidth) {
        this(trackWidth, 0.0, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003JO\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/acmerobotics/roadrunner/control/MecanumKinematics$MecanumWheelIncrements;", "Param", "Lcom/acmerobotics/roadrunner/control/WheelIncrements;", "leftFront", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "leftBack", "rightBack", "rightFront", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class MecanumWheelIncrements<Param>
    implements WheelIncrements<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> leftFront;
        @JvmField
        @NotNull
        public final DualNum<Param> leftBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightFront;

        public MecanumWheelIncrements(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            this.leftFront = leftFront;
            this.leftBack = leftBack;
            this.rightBack = rightBack;
            this.rightFront = rightFront;
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.leftFront;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.leftBack;
        }

        @NotNull
        public final DualNum<Param> component3() {
            return this.rightBack;
        }

        @NotNull
        public final DualNum<Param> component4() {
            return this.rightFront;
        }

        @NotNull
        public final MecanumWheelIncrements<Param> copy(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            return new MecanumWheelIncrements<Param>(leftFront, leftBack, rightBack, rightFront);
        }

        public static /* synthetic */ MecanumWheelIncrements copy$default(MecanumWheelIncrements mecanumWheelIncrements, DualNum dualNum, DualNum dualNum2, DualNum dualNum3, DualNum dualNum4, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = mecanumWheelIncrements.leftFront;
            }
            if ((n & 2) != 0) {
                dualNum2 = mecanumWheelIncrements.leftBack;
            }
            if ((n & 4) != 0) {
                dualNum3 = mecanumWheelIncrements.rightBack;
            }
            if ((n & 8) != 0) {
                dualNum4 = mecanumWheelIncrements.rightFront;
            }
            return mecanumWheelIncrements.copy(dualNum, dualNum2, dualNum3, dualNum4);
        }

        @NotNull
        public String toString() {
            return "MecanumWheelIncrements(leftFront=" + this.leftFront + ", leftBack=" + this.leftBack + ", rightBack=" + this.rightBack + ", rightFront=" + this.rightFront + ")";
        }

        public int hashCode() {
            int result = this.leftFront.hashCode();
            result = result * 31 + this.leftBack.hashCode();
            result = result * 31 + this.rightBack.hashCode();
            result = result * 31 + this.rightFront.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MecanumWheelIncrements)) {
                return false;
            }
            MecanumWheelIncrements mecanumWheelIncrements = (MecanumWheelIncrements)other;
            if (!Intrinsics.areEqual(this.leftFront, mecanumWheelIncrements.leftFront)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leftBack, mecanumWheelIncrements.leftBack)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rightBack, mecanumWheelIncrements.rightBack)) {
                return false;
            }
            return Intrinsics.areEqual(this.rightFront, mecanumWheelIncrements.rightFront);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000bH\u0016J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003JO\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/control/MecanumKinematics$MecanumWheelVelocities;", "Param", "Lcom/acmerobotics/roadrunner/control/WheelVelocities;", "leftFront", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "leftBack", "rightBack", "rightFront", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;)V", "all", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class MecanumWheelVelocities<Param>
    implements WheelVelocities<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> leftFront;
        @JvmField
        @NotNull
        public final DualNum<Param> leftBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightFront;

        public MecanumWheelVelocities(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            this.leftFront = leftFront;
            this.leftBack = leftBack;
            this.rightBack = rightBack;
            this.rightFront = rightFront;
        }

        @Override
        @NotNull
        public List<DualNum<Param>> all() {
            Object[] objectArray = new DualNum[]{this.leftFront, this.leftBack, this.rightBack, this.rightFront};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.leftFront;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.leftBack;
        }

        @NotNull
        public final DualNum<Param> component3() {
            return this.rightBack;
        }

        @NotNull
        public final DualNum<Param> component4() {
            return this.rightFront;
        }

        @NotNull
        public final MecanumWheelVelocities<Param> copy(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            return new MecanumWheelVelocities<Param>(leftFront, leftBack, rightBack, rightFront);
        }

        public static /* synthetic */ MecanumWheelVelocities copy$default(MecanumWheelVelocities mecanumWheelVelocities, DualNum dualNum, DualNum dualNum2, DualNum dualNum3, DualNum dualNum4, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = mecanumWheelVelocities.leftFront;
            }
            if ((n & 2) != 0) {
                dualNum2 = mecanumWheelVelocities.leftBack;
            }
            if ((n & 4) != 0) {
                dualNum3 = mecanumWheelVelocities.rightBack;
            }
            if ((n & 8) != 0) {
                dualNum4 = mecanumWheelVelocities.rightFront;
            }
            return mecanumWheelVelocities.copy(dualNum, dualNum2, dualNum3, dualNum4);
        }

        @NotNull
        public String toString() {
            return "MecanumWheelVelocities(leftFront=" + this.leftFront + ", leftBack=" + this.leftBack + ", rightBack=" + this.rightBack + ", rightFront=" + this.rightFront + ")";
        }

        public int hashCode() {
            int result = this.leftFront.hashCode();
            result = result * 31 + this.leftBack.hashCode();
            result = result * 31 + this.rightBack.hashCode();
            result = result * 31 + this.rightFront.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MecanumWheelVelocities)) {
                return false;
            }
            MecanumWheelVelocities mecanumWheelVelocities = (MecanumWheelVelocities)other;
            if (!Intrinsics.areEqual(this.leftFront, mecanumWheelVelocities.leftFront)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leftBack, mecanumWheelVelocities.leftBack)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rightBack, mecanumWheelVelocities.rightBack)) {
                return false;
            }
            return Intrinsics.areEqual(this.rightFront, mecanumWheelVelocities.rightFront);
        }
    }
}

