/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\tH\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Acceleration2d;", "", "linearAcc", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "angAcc", "", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;D)V", "integrateToVel", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "dt", "initial", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "core"})
public final class Acceleration2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Vector2d linearAcc;
    @JvmField
    public final double angAcc;
    @JvmField
    @NotNull
    public static final Acceleration2d zero = new Acceleration2d(Vector2d.zero, 0.0);

    public Acceleration2d(@NotNull Vector2d linearAcc, double angAcc) {
        Intrinsics.checkNotNullParameter((Object)linearAcc, (String)"linearAcc");
        this.linearAcc = linearAcc;
        this.angAcc = angAcc;
    }

    @JvmOverloads
    @NotNull
    public final PoseVelocity2d integrateToVel(double dt, @NotNull PoseVelocity2d initial) {
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        return new PoseVelocity2d(initial.linearVel.plus(this.linearAcc.times(dt)), initial.angVel + this.angAcc * dt);
    }

    public static /* synthetic */ PoseVelocity2d integrateToVel$default(Acceleration2d acceleration2d, double d, PoseVelocity2d poseVelocity2d, int n, Object object) {
        if ((n & 2) != 0) {
            poseVelocity2d = PoseVelocity2d.zero;
        }
        return acceleration2d.integrateToVel(d, poseVelocity2d);
    }

    @NotNull
    public final Vector2d component1() {
        return this.linearAcc;
    }

    public final double component2() {
        return this.angAcc;
    }

    @NotNull
    public final Acceleration2d copy(@NotNull Vector2d linearAcc, double angAcc) {
        Intrinsics.checkNotNullParameter((Object)linearAcc, (String)"linearAcc");
        return new Acceleration2d(linearAcc, angAcc);
    }

    public static /* synthetic */ Acceleration2d copy$default(Acceleration2d acceleration2d, Vector2d vector2d, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2d = acceleration2d.linearAcc;
        }
        if ((n & 2) != 0) {
            d = acceleration2d.angAcc;
        }
        return acceleration2d.copy(vector2d, d);
    }

    @NotNull
    public String toString() {
        return "Acceleration2d(linearAcc=" + this.linearAcc + ", angAcc=" + this.angAcc + ")";
    }

    public int hashCode() {
        int result = this.linearAcc.hashCode();
        result = result * 31 + Double.hashCode(this.angAcc);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Acceleration2d)) {
            return false;
        }
        Acceleration2d acceleration2d = (Acceleration2d)other;
        if (!Intrinsics.areEqual((Object)this.linearAcc, (Object)acceleration2d.linearAcc)) {
            return false;
        }
        return Double.compare(this.angAcc, acceleration2d.angAcc) == 0;
    }

    @JvmOverloads
    @NotNull
    public final PoseVelocity2d integrateToVel(double dt) {
        return Acceleration2d.integrateToVel$default(this, dt, null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Acceleration2d$Companion;", "", "<init>", "()V", "zero", "Lcom/acmerobotics/roadrunner/geometry/Acceleration2d;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

