/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\bJ\u0011\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0086\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u000bJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0000\"\u0004\b\u0001\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0000J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0086\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0086\u0002J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0086\u0002J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0086\u0002J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010\u001e\u001a\u00020 H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Param", "", "values", "", "<init>", "([D)V", "", "", "(Ljava/util/List;)V", "size", "", "value", "get", "i", "drop", "n", "plus", "d", "minus", "times", "unaryMinus", "recip", "div", "sqrt", "sin", "cos", "reparam", "NewParam", "oldParam", "c", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "Companion", "core"})
public final class DualNum<Param> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] values;

    public DualNum(@NotNull double[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.values = values;
        if (!(this.size() <= 4)) {
            boolean bl = false;
            String string = "Only derivatives up to 3rd order are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public DualNum(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(CollectionsKt.toDoubleArray((Collection)values));
    }

    public final int size() {
        return this.values.length;
    }

    public final double value() {
        return ArraysKt.first((double[])this.values);
    }

    public final double get(int i) {
        return this.values[i];
    }

    @NotNull
    public final List<Double> values() {
        return ArraysKt.toList((double[])this.values);
    }

    @NotNull
    public final DualNum<Param> drop(int n) {
        int n2 = 0;
        int n3 = this.size() - n;
        double[] dArray = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray[n4] = this.values[n4 + n];
        }
        double[] dArray2 = dArray;
        return new DualNum<Param>(dArray2);
    }

    @NotNull
    public final DualNum<Param> plus(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        DualNum<Param> out = new DualNum<Param>(new double[Math.min(this.size(), d.size())]);
        int n = out.values.length;
        for (int i = 0; i < n; ++i) {
            out.values[i] = this.values[i] + d.values[i];
        }
        return out;
    }

    @NotNull
    public final DualNum<Param> minus(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        DualNum<Param> out = new DualNum<Param>(new double[Math.min(this.size(), d.size())]);
        int n = out.values.length;
        for (int i = 0; i < n; ++i) {
            out.values[i] = this.values[i] - d.values[i];
        }
        return out;
    }

    @NotNull
    public final DualNum<Param> times(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        DualNum<Param> out = new DualNum<Param>(new double[Math.min(this.size(), d.size())]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = this.values[0] * d.values[0];
        if (out.size() == 1) {
            return out;
        }
        out.values[1] = this.values[0] * d.values[1] + this.values[1] * d.values[0];
        if (out.size() == 2) {
            return out;
        }
        out.values[2] = this.values[0] * d.values[2] + this.values[2] * d.values[0] + (double)2 * this.values[1] * d.values[1];
        if (out.size() == 3) {
            return out;
        }
        out.values[3] = this.values[0] * d.values[3] + this.values[3] * d.values[0] + (double)3 * (this.values[2] * d.values[1] + this.values[1] * d.values[2]);
        return out;
    }

    @NotNull
    public final DualNum<Param> unaryMinus() {
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        int n = out.values.length;
        for (int i = 0; i < n; ++i) {
            out.values[i] = -this.values[i];
        }
        return out;
    }

    @NotNull
    public final DualNum<Param> recip() {
        double deriv2;
        double deriv;
        double recip;
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = recip = 1.0 / this.values[0];
        if (out.size() == 1) {
            return out;
        }
        double negRecip = -recip;
        double negRecip2 = recip * negRecip;
        out.values[1] = deriv = negRecip2 * this.values[1];
        if (out.size() == 2) {
            return out;
        }
        double int1 = (double)2 * negRecip * deriv;
        out.values[2] = deriv2 = int1 * this.values[1] + negRecip2 * this.values[2];
        if (out.size() == 3) {
            return out;
        }
        double int2 = int1 * this.values[2];
        out.values[3] = int2 + negRecip2 * this.values[3] + int2 - (double)2 * (deriv * deriv + recip * deriv2) * this.values[1];
        return out;
    }

    @NotNull
    public final DualNum<Param> div(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        return this.times(d.recip());
    }

    @NotNull
    public final DualNum<Param> sqrt() {
        double secondDeriv;
        double deriv;
        double sqrt;
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = sqrt = Math.sqrt(this.values[0]);
        if (out.size() == 1) {
            return out;
        }
        double recip = 1.0 / ((double)2 * sqrt);
        out.values[1] = deriv = recip * this.values[1];
        if (out.size() == 2) {
            return out;
        }
        double negRecip = (double)-2 * recip;
        double negRecip2 = recip * negRecip;
        double int1 = negRecip2 * deriv;
        out.values[2] = secondDeriv = int1 * this.values[1] + recip * this.values[2];
        if (out.size() == 3) {
            return out;
        }
        double int2 = (double)2 * int1;
        out.values[3] = recip * this.values[3] + int2 * this.values[2] + (deriv * negRecip * int2 + negRecip2 * secondDeriv) * this.values[1];
        return out;
    }

    @NotNull
    public final DualNum<Param> sin() {
        double deriv;
        double sin;
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = sin = Math.sin(this.values[0]);
        if (out.size() == 1) {
            return out;
        }
        double cos = Math.cos(this.values[0]);
        out.values[1] = deriv = cos * this.values[1];
        if (out.size() == 2) {
            return out;
        }
        double inDeriv2 = this.values[1] * this.values[1];
        out.values[2] = cos * this.values[2] - sin * inDeriv2;
        if (out.size() == 3) {
            return out;
        }
        out.values[3] = cos * this.values[3] - (double)3 * sin * this.values[1] * this.values[2] - deriv * inDeriv2;
        return out;
    }

    @NotNull
    public final DualNum<Param> cos() {
        double deriv;
        double cos;
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = cos = Math.cos(this.values[0]);
        if (out.size() == 1) {
            return out;
        }
        double sin = Math.sin(this.values[0]);
        double negInDeriv = -this.values[1];
        out.values[1] = deriv = sin * negInDeriv;
        if (out.size() == 2) {
            return out;
        }
        double d = cos * negInDeriv;
        out.values[2] = d * this.values[1] - sin * this.values[2];
        if (out.size() == 3) {
            return out;
        }
        out.values[3] = deriv * negInDeriv * this.values[1] + (double)3 * d * this.values[2] - sin * this.values[3];
        return out;
    }

    @NotNull
    public final <NewParam> DualNum<NewParam> reparam(@NotNull DualNum<NewParam> oldParam) {
        Intrinsics.checkNotNullParameter(oldParam, (String)"oldParam");
        DualNum<Param> out = new DualNum<Param>(new double[Math.min(this.size(), oldParam.size())]);
        if (out.values.length == 0) {
            return out;
        }
        out.values[0] = this.values[0];
        if (out.size() == 1) {
            return out;
        }
        out.values[1] = this.values[1] * oldParam.get(1);
        if (out.size() == 2) {
            return out;
        }
        double oldDeriv2 = oldParam.values[1] * oldParam.values[1];
        out.values[2] = oldDeriv2 * this.values[2] + oldParam.values[2] * this.values[1];
        if (out.size() == 3) {
            return out;
        }
        out.values[3] = this.values[1] * oldParam.values[3] + ((double)3 * this.values[2] * oldParam.values[2] + this.values[3] * oldDeriv2) * oldParam.values[1];
        return out;
    }

    @NotNull
    public final DualNum<Param> plus(double c) {
        int n = this.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = n2 == 0 ? this.values[0] + c : this.values[n2];
        }
        double[] dArray2 = dArray;
        return new DualNum<Param>(dArray2);
    }

    @NotNull
    public final DualNum<Param> minus(double c) {
        int n = this.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = n2 == 0 ? this.values[0] - c : this.values[n2];
        }
        double[] dArray2 = dArray;
        return new DualNum<Param>(dArray2);
    }

    @NotNull
    public final DualNum<Param> times(double c) {
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        int n = out.values.length;
        for (int i = 0; i < n; ++i) {
            out.values[i] = this.values[i] * c;
        }
        return out;
    }

    @NotNull
    public final DualNum<Param> div(double c) {
        DualNum<Param> out = new DualNum<Param>(new double[this.size()]);
        int n = out.values.length;
        for (int i = 0; i < n; ++i) {
            out.values[i] = this.values[i] / c;
        }
        return out;
    }

    @NotNull
    public final Vector2dDual<Param> times(@NotNull Vector2d c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Vector2dDual<Param>(this.times(c.x), this.times(c.y));
    }

    @JvmStatic
    @NotNull
    public static final <Param> DualNum<Param> constant(double c, int n) {
        return Companion.constant(c, n);
    }

    @JvmStatic
    @NotNull
    public static final <Param> DualNum<Param> variable(double x0, int n) {
        return Companion.variable(x0, n);
    }

    @JvmStatic
    @NotNull
    public static final <Param> DualNum<Param> cons(double x, @NotNull DualNum<Param> d) {
        return Companion.cons(x, d);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J*\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/acmerobotics/roadrunner/geometry/DualNum$Companion;", "", "<init>", "()V", "constant", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Param", "c", "", "n", "", "variable", "x0", "cons", "x", "d", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Param> DualNum<Param> constant(double c, int n) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray[n2] = n2 == 0 ? c : 0.0;
            }
            double[] dArray2 = dArray;
            return new DualNum(dArray2);
        }

        @JvmStatic
        @NotNull
        public final <Param> DualNum<Param> variable(double x0, int n) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray[n2] = switch (n2) {
                    case 0 -> x0;
                    case 1 -> 1.0;
                    default -> 0.0;
                };
            }
            double[] dArray2 = dArray;
            return new DualNum(dArray2);
        }

        @JvmStatic
        @NotNull
        public final <Param> DualNum<Param> cons(double x, @NotNull DualNum<Param> d) {
            Intrinsics.checkNotNullParameter(d, (String)"d");
            int n = d.size() + 1;
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray[n2] = n2 == 0 ? x : ((DualNum)d).values[n2 - 1];
            }
            double[] dArray2 = dArray;
            return new DualNum(dArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

