/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Twist2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u000fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "", "position", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "heading", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Rotation2d;)V", "", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;D)V", "positionX", "positionY", "(DDD)V", "plus", "t", "Lcom/acmerobotics/roadrunner/geometry/Twist2d;", "minusExp", "minus", "times", "p", "v", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "pv", "inverse", "log", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "core"})
public final class Pose2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Vector2d position;
    @JvmField
    @NotNull
    public final Rotation2d heading;
    @JvmField
    @NotNull
    public static final Pose2d zero = new Pose2d(Vector2d.zero, Rotation2d.zero);

    public Pose2d(@NotNull Vector2d position, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        this.position = position;
        this.heading = heading;
    }

    public Pose2d(@NotNull Vector2d position, double heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(position, Rotation2d.Companion.exp(heading));
    }

    public Pose2d(double positionX, double positionY, double heading) {
        this(new Vector2d(positionX, positionY), heading);
    }

    @NotNull
    public final Pose2d plus(@NotNull Twist2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.times(Companion.exp(t));
    }

    @NotNull
    public final Pose2d minusExp(@NotNull Pose2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return t.inverse().times(this);
    }

    @NotNull
    public final Twist2d minus(@NotNull Pose2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.minusExp(t).log();
    }

    @NotNull
    public final Pose2d times(@NotNull Pose2d p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new Pose2d(this.heading.times(p.position).plus(this.position), this.heading.times(p.heading));
    }

    @NotNull
    public final Vector2d times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.heading.times(v).plus(this.position);
    }

    @NotNull
    public final PoseVelocity2d times(@NotNull PoseVelocity2d pv) {
        Intrinsics.checkNotNullParameter((Object)pv, (String)"pv");
        return new PoseVelocity2d(this.heading.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Pose2d inverse() {
        return new Pose2d(this.heading.inverse().times(this.position.unaryMinus()), this.heading.inverse());
    }

    @NotNull
    public final Twist2d log() {
        double theta = this.heading.log();
        double halfu = 0.5 * theta + Math.snz(theta);
        double v = halfu / java.lang.Math.tan(halfu);
        return new Twist2d(new Vector2d(v * this.position.x + halfu * this.position.y, -halfu * this.position.x + v * this.position.y), theta);
    }

    @NotNull
    public final Vector2d component1() {
        return this.position;
    }

    @NotNull
    public final Rotation2d component2() {
        return this.heading;
    }

    @NotNull
    public final Pose2d copy(@NotNull Vector2d position, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return new Pose2d(position, heading);
    }

    public static /* synthetic */ Pose2d copy$default(Pose2d pose2d, Vector2d vector2d, Rotation2d rotation2d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2d = pose2d.position;
        }
        if ((n & 2) != 0) {
            rotation2d = pose2d.heading;
        }
        return pose2d.copy(vector2d, rotation2d);
    }

    @NotNull
    public String toString() {
        return "Pose2d(position=" + this.position + ", heading=" + this.heading + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.heading.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pose2d)) {
            return false;
        }
        Pose2d pose2d = (Pose2d)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)pose2d.position)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.heading, (Object)pose2d.heading);
    }

    @JvmStatic
    @NotNull
    public static final Pose2d exp(@NotNull Twist2d t) {
        return Companion.exp(t);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Pose2d$Companion;", "", "<init>", "()V", "exp", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "t", "Lcom/acmerobotics/roadrunner/geometry/Twist2d;", "zero", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Pose2d exp(@NotNull Twist2d t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Rotation2d heading = Rotation2d.Companion.exp(t.angle);
            double u = t.angle + Math.snz(t.angle);
            double c = 1.0 - java.lang.Math.cos(u);
            double s = java.lang.Math.sin(u);
            Vector2d translation = new Vector2d((s * t.line.x - c * t.line.y) / u, (c * t.line.x + s * t.line.y) / u);
            return new Pose2d(translation, heading);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

