/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "", "real", "", "imag", "<init>", "(DD)V", "plus", "x", "minus", "r", "times", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "v", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "pv", "vec", "inverse", "log", "toDouble", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "core"})
public final class Rotation2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final double real;
    @JvmField
    public final double imag;
    @JvmField
    @NotNull
    public static final Rotation2d zero = new Rotation2d(0.0, 0.0);

    public Rotation2d(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    @NotNull
    public final Rotation2d plus(double x) {
        return this.times(Companion.exp(x));
    }

    public final double minus(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.inverse().times(this).log();
    }

    @NotNull
    public final Vector2d times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2d(this.real * v.x - this.imag * v.y, this.imag * v.x + this.real * v.y);
    }

    @NotNull
    public final PoseVelocity2d times(@NotNull PoseVelocity2d pv) {
        Intrinsics.checkNotNullParameter((Object)pv, (String)"pv");
        return new PoseVelocity2d(this.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Rotation2d times(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new Rotation2d(this.real * r.real - this.imag * r.imag, this.real * r.imag + this.imag * r.real);
    }

    @NotNull
    public final Vector2d vec() {
        return new Vector2d(this.real, this.imag);
    }

    @NotNull
    public final Rotation2d inverse() {
        return new Rotation2d(this.real, -this.imag);
    }

    public final double log() {
        return Math.atan2(this.imag, this.real);
    }

    public final double toDouble() {
        return this.log();
    }

    public final double component1() {
        return this.real;
    }

    public final double component2() {
        return this.imag;
    }

    @NotNull
    public final Rotation2d copy(double real, double imag) {
        return new Rotation2d(real, imag);
    }

    public static /* synthetic */ Rotation2d copy$default(Rotation2d rotation2d, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = rotation2d.real;
        }
        if ((n & 2) != 0) {
            d2 = rotation2d.imag;
        }
        return rotation2d.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Rotation2d(real=" + this.real + ", imag=" + this.imag + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.real);
        result = result * 31 + Double.hashCode(this.imag);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation2d)) {
            return false;
        }
        Rotation2d rotation2d = (Rotation2d)other;
        if (Double.compare(this.real, rotation2d.real) != 0) {
            return false;
        }
        return Double.compare(this.imag, rotation2d.imag) == 0;
    }

    @JvmStatic
    @NotNull
    public static final Rotation2d exp(double theta) {
        return Companion.exp(theta);
    }

    @JvmStatic
    @NotNull
    public static final Rotation2d fromDouble(double theta) {
        return Companion.fromDouble(theta);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2d$Companion;", "", "<init>", "()V", "exp", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "theta", "", "fromDouble", "zero", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Rotation2d exp(double theta) {
            return new Rotation2d(Math.cos(theta), Math.sin(theta));
        }

        @JvmStatic
        @NotNull
        public final Rotation2d fromDouble(double theta) {
            return this.exp(theta);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

