/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001)B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0086\u0002J\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0086\u0002J\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0086\u0002J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0000\"\u0004\b\u0001\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0004J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\u0006\u0010\u001e\u001a\u00020\u0015J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J/\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010&\u001a\u00020\tH\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Param", "", "real", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "imag", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;)V", "size", "", "plus", "x", "", "d", "times", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "pv", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "v", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "r", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "p", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "inverse", "reparam", "NewParam", "oldParam", "velocity", "value", "log", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ncom/acmerobotics/roadrunner/geometry/Rotation2dDual\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,486:1\n1#2:487\n*E\n"})
public final class Rotation2dDual<Param> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final DualNum<Param> real;
    @JvmField
    @NotNull
    public final DualNum<Param> imag;

    public Rotation2dDual(@NotNull DualNum<Param> real, @NotNull DualNum<Param> imag) {
        Intrinsics.checkNotNullParameter(real, (String)"real");
        Intrinsics.checkNotNullParameter(imag, (String)"imag");
        this.real = real;
        this.imag = imag;
        if (!(this.real.size() == this.imag.size())) {
            boolean $i$a$-require-Rotation2dDual$32 = false;
            String $i$a$-require-Rotation2dDual$32 = "Real and imaginary parts must have the same size";
            throw new IllegalArgumentException($i$a$-require-Rotation2dDual$32.toString());
        }
        if (!(this.real.size() <= 3)) {
            boolean bl = false;
            String string = "Only derivatives up to 2nd order are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int size() {
        return this.real.size();
    }

    @NotNull
    public final Rotation2dDual<Param> plus(double x) {
        return this.times(Rotation2d.Companion.exp(x));
    }

    @NotNull
    public final Rotation2dDual<Param> plus(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        return this.times(Companion.exp(d));
    }

    @NotNull
    public final PoseVelocity2dDual<Param> times(@NotNull PoseVelocity2dDual<Param> pv) {
        Intrinsics.checkNotNullParameter(pv, (String)"pv");
        return new PoseVelocity2dDual(this.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Vector2dDual<Param> times(@NotNull Vector2dDual<Param> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return new Vector2dDual<Param>(this.real.times(v.x).minus(this.imag.times(v.y)), this.imag.times(v.x).plus(this.real.times(v.y)));
    }

    @NotNull
    public final Vector2dDual<Param> times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2dDual<Param>(this.real.times(v.x).minus(this.imag.times(v.y)), this.imag.times(v.x).plus(this.real.times(v.y)));
    }

    @NotNull
    public final Rotation2dDual<Param> times(@NotNull Rotation2dDual<Param> r) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        return new Rotation2dDual<Param>(this.real.times(r.real).minus(this.imag.times(r.imag)), this.real.times(r.imag).plus(this.imag.times(r.real)));
    }

    @NotNull
    public final Rotation2dDual<Param> times(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new Rotation2dDual<Param>(this.real.times(r.real).minus(this.imag.times(r.imag)), this.real.times(r.imag).plus(this.imag.times(r.real)));
    }

    @NotNull
    public final Pose2dDual<Param> times(@NotNull Pose2d p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new Pose2dDual<Param>(this.times(p.position), this.times(p.heading));
    }

    @NotNull
    public final Rotation2dDual<Param> inverse() {
        return new Rotation2dDual<Param>(this.real, this.imag.unaryMinus());
    }

    @NotNull
    public final <NewParam> Rotation2dDual<NewParam> reparam(@NotNull DualNum<NewParam> oldParam) {
        Intrinsics.checkNotNullParameter(oldParam, (String)"oldParam");
        return new Rotation2dDual<NewParam>(this.real.reparam(oldParam), this.imag.reparam(oldParam));
    }

    @NotNull
    public final DualNum<Param> velocity() {
        return this.real.times(this.imag.drop(1)).minus(this.imag.times(this.real.drop(1)));
    }

    @NotNull
    public final Rotation2d value() {
        return new Rotation2d(this.real.value(), this.imag.value());
    }

    @NotNull
    public final DualNum<Param> log() {
        int n = 0;
        int n2 = this.size();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = new Rotation2d(this.real.get(n3), this.imag.get(n3)).log();
        }
        double[] dArray2 = dArray;
        return new DualNum(dArray2);
    }

    @NotNull
    public final DualNum<Param> component1() {
        return this.real;
    }

    @NotNull
    public final DualNum<Param> component2() {
        return this.imag;
    }

    @NotNull
    public final Rotation2dDual<Param> copy(@NotNull DualNum<Param> real, @NotNull DualNum<Param> imag) {
        Intrinsics.checkNotNullParameter(real, (String)"real");
        Intrinsics.checkNotNullParameter(imag, (String)"imag");
        return new Rotation2dDual<Param>(real, imag);
    }

    public static /* synthetic */ Rotation2dDual copy$default(Rotation2dDual rotation2dDual, DualNum dualNum, DualNum dualNum2, int n, Object object) {
        if ((n & 1) != 0) {
            dualNum = rotation2dDual.real;
        }
        if ((n & 2) != 0) {
            dualNum2 = rotation2dDual.imag;
        }
        return rotation2dDual.copy(dualNum, dualNum2);
    }

    @NotNull
    public String toString() {
        return "Rotation2dDual(real=" + this.real + ", imag=" + this.imag + ")";
    }

    public int hashCode() {
        int result = this.real.hashCode();
        result = result * 31 + this.imag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation2dDual)) {
            return false;
        }
        Rotation2dDual rotation2dDual = (Rotation2dDual)other;
        if (!Intrinsics.areEqual(this.real, rotation2dDual.real)) {
            return false;
        }
        return Intrinsics.areEqual(this.imag, rotation2dDual.imag);
    }

    @JvmStatic
    @NotNull
    public static final <Param> Rotation2dDual<Param> exp(@NotNull DualNum<Param> theta) {
        return Companion.exp(theta);
    }

    @JvmStatic
    @NotNull
    public static final <Param> Rotation2dDual<Param> constant(@NotNull Rotation2d r, int n) {
        return Companion.constant(r, n);
    }

    @JvmStatic
    @NotNull
    public static final <Param> Rotation2dDual<Param> zero() {
        return Companion.zero();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007J$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual$Companion;", "", "<init>", "()V", "exp", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Param", "theta", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "constant", "r", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "n", "", "zero", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Param> Rotation2dDual<Param> exp(@NotNull DualNum<Param> theta) {
            Intrinsics.checkNotNullParameter(theta, (String)"theta");
            return new Rotation2dDual<Param>(theta.cos(), theta.sin());
        }

        @JvmStatic
        @NotNull
        public final <Param> Rotation2dDual<Param> constant(@NotNull Rotation2d r, int n) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Rotation2dDual(DualNum.Companion.constant(r.real, n), DualNum.Companion.constant(r.imag, n));
        }

        @JvmStatic
        @NotNull
        public final <Param> Rotation2dDual<Param> zero() {
            return this.constant(Rotation2d.zero, 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

