/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001(B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0004J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0000\"\u0004\b\u0001\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\nJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001e\u0010\u001d\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001eJ\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J/\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010%\u001a\u00020\u0019H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "Param", "", "x", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "y", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;)V", "plus", "v", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "minus", "unaryMinus", "div", "z", "", "dot", "sqrNorm", "norm", "bind", "reparam", "NewParam", "oldParam", "drop", "n", "", "value", "angleCast", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "asPair", "Lkotlin/Pair;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "core"})
public final class Vector2dDual<Param> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final DualNum<Param> x;
    @JvmField
    @NotNull
    public final DualNum<Param> y;

    public Vector2dDual(@NotNull DualNum<Param> x, @NotNull DualNum<Param> y) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        this.x = x;
        this.y = y;
    }

    @NotNull
    public final Vector2dDual<Param> plus(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2dDual<Param>(this.x.plus(v.x), this.y.plus(v.y));
    }

    @NotNull
    public final Vector2dDual<Param> plus(@NotNull Vector2dDual<Param> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return new Vector2dDual<Param>(this.x.plus(v.x), this.y.plus(v.y));
    }

    @NotNull
    public final Vector2dDual<Param> minus(@NotNull Vector2dDual<Param> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return new Vector2dDual<Param>(this.x.minus(v.x), this.y.minus(v.y));
    }

    @NotNull
    public final Vector2dDual<Param> unaryMinus() {
        return new Vector2dDual<Param>(this.x.unaryMinus(), this.y.unaryMinus());
    }

    @NotNull
    public final Vector2dDual<Param> div(double z) {
        return new Vector2dDual<Param>(this.x.div(z), this.y.div(z));
    }

    @NotNull
    public final DualNum<Param> dot(@NotNull Vector2dDual<Param> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.x.times(v.x).plus(this.y.times(v.y));
    }

    @NotNull
    public final DualNum<Param> sqrNorm() {
        return this.dot(this);
    }

    @NotNull
    public final DualNum<Param> norm() {
        return this.sqrNorm().sqrt();
    }

    @NotNull
    public final Vector2dDual<Param> bind() {
        return new Vector2dDual<Param>(this.x, this.y);
    }

    @NotNull
    public final <NewParam> Vector2dDual<NewParam> reparam(@NotNull DualNum<NewParam> oldParam) {
        Intrinsics.checkNotNullParameter(oldParam, (String)"oldParam");
        return new Vector2dDual<NewParam>(this.x.reparam(oldParam), this.y.reparam(oldParam));
    }

    @NotNull
    public final Vector2dDual<Param> drop(int n) {
        return new Vector2dDual<Param>(this.x.drop(n), this.y.drop(n));
    }

    @NotNull
    public final Vector2d value() {
        return new Vector2d(this.x.value(), this.y.value());
    }

    @NotNull
    public final Rotation2dDual<Param> angleCast() {
        return new Rotation2dDual<Param>(this.x, this.y);
    }

    @NotNull
    public final Pair<DualNum<Param>, DualNum<Param>> asPair() {
        return TuplesKt.to(this.x, this.y);
    }

    @NotNull
    public final DualNum<Param> component1() {
        return this.x;
    }

    @NotNull
    public final DualNum<Param> component2() {
        return this.y;
    }

    @NotNull
    public final Vector2dDual<Param> copy(@NotNull DualNum<Param> x, @NotNull DualNum<Param> y) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        return new Vector2dDual<Param>(x, y);
    }

    public static /* synthetic */ Vector2dDual copy$default(Vector2dDual vector2dDual, DualNum dualNum, DualNum dualNum2, int n, Object object) {
        if ((n & 1) != 0) {
            dualNum = vector2dDual.x;
        }
        if ((n & 2) != 0) {
            dualNum2 = vector2dDual.y;
        }
        return vector2dDual.copy(dualNum, dualNum2);
    }

    @NotNull
    public String toString() {
        return "Vector2dDual(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = result * 31 + this.y.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector2dDual)) {
            return false;
        }
        Vector2dDual vector2dDual = (Vector2dDual)other;
        if (!Intrinsics.areEqual(this.x, vector2dDual.x)) {
            return false;
        }
        return Intrinsics.areEqual(this.y, vector2dDual.y);
    }

    @JvmStatic
    @NotNull
    public static final <Param> Vector2dDual<Param> constant(@NotNull Vector2d v, int n) {
        return Companion.constant(v, n);
    }

    @JvmStatic
    @NotNull
    public static final <Param> Vector2dDual<Param> zero() {
        return Companion.zero();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Vector2dDual$Companion;", "", "<init>", "()V", "constant", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "Param", "v", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "n", "", "zero", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Param> Vector2dDual<Param> constant(@NotNull Vector2d v, int n) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return new Vector2dDual(DualNum.Companion.constant(v.x, n), DualNum.Companion.constant(v.y, n));
        }

        @JvmStatic
        @NotNull
        public final <Param> Vector2dDual<Param> zero() {
            return this.constant(Vector2d.zero, 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

