/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.IntegralScanResult;
import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.PositionPath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u000b\u001a\u00020\tH\u0016J\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0001H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/acmerobotics/roadrunner/paths/ArclengthReparamCurve2d;", "Lcom/acmerobotics/roadrunner/paths/PositionPath;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "curve", "samples", "Lcom/acmerobotics/roadrunner/geometry/IntegralScanResult;", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PositionPath;Lcom/acmerobotics/roadrunner/geometry/IntegralScanResult;)V", "eps", "", "(Lcom/acmerobotics/roadrunner/paths/PositionPath;D)V", "length", "reparam", "s", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "param", "n", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
public final class ArclengthReparamCurve2d
implements PositionPath<Arclength> {
    @JvmField
    @NotNull
    public final PositionPath<?> curve;
    @JvmField
    @NotNull
    public final IntegralScanResult samples;
    @JvmField
    public final double length;

    public ArclengthReparamCurve2d(@NotNull PositionPath<?> curve, @NotNull IntegralScanResult samples) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        this.curve = curve;
        this.samples = samples;
        this.length = ((Number)CollectionsKt.last(this.samples.sums)).doubleValue();
    }

    public ArclengthReparamCurve2d(@NotNull PositionPath<?> curve, double eps) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        this(curve, Math.integralScan(0.0, curve.length(), eps, (Function1<? super Double, Double>)((Function1)arg_0 -> ArclengthReparamCurve2d._init_$lambda$0(curve, arg_0))));
    }

    public final double reparam(double s) {
        return Math.lerpLookup(this.samples.sums, this.samples.values, s);
    }

    @Override
    @NotNull
    public Vector2dDual<Arclength> get(double param, int n) {
        double t = this.reparam(param);
        Vector2dDual<?> point = this.curve.get(t, n);
        double[] tValues = new double[n];
        tValues[0] = t;
        if (n <= 1) {
            return point.reparam(new DualNum(tValues));
        }
        DualNum<?> tDerivs = point.drop(1).norm().recip();
        tValues[1] = tDerivs.get(0);
        if (n <= 2) {
            return point.reparam(new DualNum(tValues));
        }
        tValues[2] = tDerivs.reparam(new DualNum(tValues)).get(1);
        if (n <= 3) {
            return point.reparam(new DualNum(tValues));
        }
        tValues[3] = tDerivs.reparam(new DualNum(tValues)).get(2);
        return point.reparam(new DualNum(tValues));
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final PositionPath<?> component1() {
        return this.curve;
    }

    @NotNull
    public final IntegralScanResult component2() {
        return this.samples;
    }

    @NotNull
    public final ArclengthReparamCurve2d copy(@NotNull PositionPath<?> curve, @NotNull IntegralScanResult samples) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return new ArclengthReparamCurve2d(curve, samples);
    }

    public static /* synthetic */ ArclengthReparamCurve2d copy$default(ArclengthReparamCurve2d arclengthReparamCurve2d, PositionPath positionPath, IntegralScanResult integralScanResult, int n, Object object) {
        if ((n & 1) != 0) {
            positionPath = arclengthReparamCurve2d.curve;
        }
        if ((n & 2) != 0) {
            integralScanResult = arclengthReparamCurve2d.samples;
        }
        return arclengthReparamCurve2d.copy(positionPath, integralScanResult);
    }

    @NotNull
    public String toString() {
        return "ArclengthReparamCurve2d(curve=" + this.curve + ", samples=" + this.samples + ")";
    }

    public int hashCode() {
        int result = this.curve.hashCode();
        result = result * 31 + this.samples.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArclengthReparamCurve2d)) {
            return false;
        }
        ArclengthReparamCurve2d arclengthReparamCurve2d = (ArclengthReparamCurve2d)other;
        if (!Intrinsics.areEqual(this.curve, arclengthReparamCurve2d.curve)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.samples, (Object)arclengthReparamCurve2d.samples);
    }

    private static final double _init_$lambda$0(PositionPath $curve, double it) {
        return $curve.get(it, 2).drop(1).value().norm();
    }
}

