/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Internal;
import com.acmerobotics.roadrunner.paths.QuinticSpline1d;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0086\u0002J\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\fH\u0086\u0002J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\fJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;", "", "coefficients", "", "", "<init>", "(Ljava/util/List;)V", "", "([D)V", "getCoefficients", "()Ljava/util/List;", "dim", "", "getDim", "()I", "get", "t", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Lcom/acmerobotics/roadrunner/geometry/Internal;", "n", "derivative", "nthDerivative", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBezierCurves.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BezierCurves.kt\ncom/acmerobotics/roadrunner/paths/BezierCurve1d\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1803#3,3:100\n*S KotlinDebug\n*F\n+ 1 BezierCurves.kt\ncom/acmerobotics/roadrunner/paths/BezierCurve1d\n*L\n48#1:100,3\n*E\n"})
public final class BezierCurve1d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Double> coefficients;
    private final int dim;

    public BezierCurve1d(@NotNull List<Double> coefficients) {
        Intrinsics.checkNotNullParameter(coefficients, (String)"coefficients");
        this.coefficients = coefficients;
        this.dim = this.coefficients.size() - 1;
    }

    @NotNull
    public final List<Double> getCoefficients() {
        return this.coefficients;
    }

    public BezierCurve1d(@NotNull double[] coefficients) {
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        this(ArraysKt.toList((double[])coefficients));
    }

    public final int getDim() {
        return this.dim;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(double t) {
        Iterable iterable = (Iterable)new IntRange(0, this.dim);
        double d = 0.0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void i;
            int n;
            int n2 = n = ((IntIterator)iterator).nextInt();
            double d2 = d;
            boolean bl = false;
            double d3 = (double)BezierCurve1d.Companion.bi(this.dim, (int)i) * Math.pow(1.0 - t, this.dim - i) * Math.pow(t, (double)i) * ((Number)this.coefficients.get((int)i)).doubleValue();
            d = d2 + d3;
        }
        return d;
    }

    @NotNull
    public final DualNum<Internal> get(double t, int n) {
        int n2 = 0;
        double[] dArray = new double[n];
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = this.nthDerivative(n3).get(t);
        }
        double[] dArray2 = dArray;
        return new DualNum<Internal>(dArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BezierCurve1d derivative() {
        int n = this.dim;
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add((double)this.dim * (((Number)this.coefficients.get((int)(i + true))).doubleValue() - ((Number)this.coefficients.get((int)i)).doubleValue()));
        }
        List list = arrayList;
        return new BezierCurve1d(list);
    }

    @NotNull
    public final BezierCurve1d nthDerivative(int n) {
        if (n == 0) {
            return this;
        }
        if (this.coefficients.size() <= n) {
            int n2 = this.coefficients.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = n4 = n3++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0.0);
            }
            List list = arrayList;
            return new BezierCurve1d(list);
        }
        Iterable $this$fold$iv = (Iterable)RangesKt.until((int)0, (int)n);
        boolean $i$f$fold = false;
        BezierCurve1d accumulator$iv = this;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            BezierCurve1d acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.derivative();
        }
        return accumulator$iv;
    }

    @NotNull
    public final List<Double> component1() {
        return this.coefficients;
    }

    @NotNull
    public final BezierCurve1d copy(@NotNull List<Double> coefficients) {
        Intrinsics.checkNotNullParameter(coefficients, (String)"coefficients");
        return new BezierCurve1d(coefficients);
    }

    public static /* synthetic */ BezierCurve1d copy$default(BezierCurve1d bezierCurve1d, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = bezierCurve1d.coefficients;
        }
        return bezierCurve1d.copy(list);
    }

    @NotNull
    public String toString() {
        return "BezierCurve1d(coefficients=" + this.coefficients + ")";
    }

    public int hashCode() {
        return ((Object)this.coefficients).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve1d)) {
            return false;
        }
        BezierCurve1d bezierCurve1d = (BezierCurve1d)other;
        return Intrinsics.areEqual(this.coefficients, bezierCurve1d.coefficients);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/acmerobotics/roadrunner/paths/BezierCurve1d$Companion;", "", "<init>", "()V", "bi", "", "other", "fromRRSpline", "Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;", "spline", "Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int bi(int $this$bi, int other) {
            if (other < 0 || other > $this$bi) {
                return 0;
            }
            if (other == 0 || other == $this$bi) {
                return 1;
            }
            return com.acmerobotics.roadrunner.geometry.Math.fact($this$bi) / (com.acmerobotics.roadrunner.geometry.Math.fact(other) * com.acmerobotics.roadrunner.geometry.Math.fact($this$bi - other));
        }

        @NotNull
        public final BezierCurve1d fromRRSpline(@NotNull QuinticSpline1d spline) {
            Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
            double[] dArray = new double[]{spline.f, spline.f + 0.2 * spline.e, spline.f + 0.4 * spline.e + 0.1 * spline.d, spline.f + 0.6 * spline.e + 0.3 * spline.d + 0.1 * spline.c, spline.f + 0.8 * spline.e + 0.6 * spline.d + 0.4 * spline.c + 0.2 * spline.b, CollectionsKt.sumOfDouble((Iterable)spline.getCoefficients())};
            return new BezierCurve1d(dArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

