/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Geometry;
import com.acmerobotics.roadrunner.geometry.Internal;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.BezierCurve1d;
import com.acmerobotics.roadrunner.paths.PositionPath;
import com.acmerobotics.roadrunner.paths.QuinticSpline2dInternal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0006\u0010\fB\u0017\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/acmerobotics/roadrunner/paths/BezierCurve2dInternal;", "Lcom/acmerobotics/roadrunner/paths/PositionPath;", "Lcom/acmerobotics/roadrunner/geometry/Internal;", "x", "Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;", "y", "<init>", "(Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;)V", "xs", "", "", "ys", "(Ljava/util/List;Ljava/util/List;)V", "points", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "(Ljava/util/List;)V", "getX", "()Lcom/acmerobotics/roadrunner/paths/BezierCurve1d;", "getY", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "t", "n", "", "length", "getLength", "()D", "Companion", "core"})
public final class BezierCurve2dInternal
implements PositionPath<Internal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BezierCurve1d x;
    @NotNull
    private final BezierCurve1d y;
    private final double length;

    public BezierCurve2dInternal(@NotNull BezierCurve1d x, @NotNull BezierCurve1d y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.x = x;
        this.y = y;
        this.length = 1.0;
    }

    @NotNull
    public final BezierCurve1d getX() {
        return this.x;
    }

    @NotNull
    public final BezierCurve1d getY() {
        return this.y;
    }

    public BezierCurve2dInternal(@NotNull List<Double> xs, @NotNull List<Double> ys) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        this(new BezierCurve1d(xs), new BezierCurve1d(ys));
    }

    public BezierCurve2dInternal(@NotNull List<Vector2d> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this(Geometry.xs(points), Geometry.ys(points));
    }

    @Override
    @NotNull
    public Vector2dDual<Internal> get(double t, int n) {
        return new Vector2dDual<Internal>(this.x.get(t, n), this.y.get(t, n));
    }

    public final double getLength() {
        return this.length;
    }

    @Override
    public double length() {
        return this.length;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\t\"\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/acmerobotics/roadrunner/paths/BezierCurve2dInternal$Companion;", "", "<init>", "()V", "fromPoints", "Lcom/acmerobotics/roadrunner/paths/BezierCurve2dInternal;", "points", "", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "", "([Lcom/acmerobotics/roadrunner/geometry/Vector2d;)Lcom/acmerobotics/roadrunner/paths/BezierCurve2dInternal;", "fromRRSpline", "spline", "Lcom/acmerobotics/roadrunner/paths/QuinticSpline2dInternal;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BezierCurve2dInternal fromPoints(@NotNull List<Vector2d> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return new BezierCurve2dInternal(Geometry.xs(points), Geometry.ys(points));
        }

        @NotNull
        public final BezierCurve2dInternal fromPoints(Vector2d ... points) {
            Intrinsics.checkNotNullParameter((Object)points, (String)"points");
            return this.fromPoints(ArraysKt.toList((Object[])points));
        }

        @NotNull
        public final BezierCurve2dInternal fromRRSpline(@NotNull QuinticSpline2dInternal spline) {
            Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
            return new BezierCurve2dInternal(BezierCurve1d.Companion.fromRRSpline(spline.x), BezierCurve1d.Companion.fromRRSpline(spline.y));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

