/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.paths.PosePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0001H\u0096\u0002J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/acmerobotics/roadrunner/paths/CompositePosePath;", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "paths", "", "offsets", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "s", "n", "", "plus", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nPosePaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosePaths.kt\ncom/acmerobotics/roadrunner/paths/CompositePosePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n3067#2:167\n2967#2,3:168\n2970#2,6:172\n1#3:171\n*S KotlinDebug\n*F\n+ 1 PosePaths.kt\ncom/acmerobotics/roadrunner/paths/CompositePosePath\n*L\n73#1:167\n73#1:168,3\n73#1:172,6\n73#1:171\n*E\n"})
public final class CompositePosePath
implements PosePath {
    @JvmField
    @NotNull
    public final List<PosePath> paths;
    @JvmField
    @NotNull
    public final List<Double> offsets;
    @JvmField
    public final double length;

    @JvmOverloads
    public CompositePosePath(@NotNull List<? extends PosePath> paths, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.paths = paths;
        this.offsets = offsets;
        if (!(this.paths.size() + 1 == this.offsets.size())) {
            boolean bl = false;
            String string = "paths.size (" + this.paths.size() + ") + 1 != offsets.size (" + this.offsets.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.length = ((Number)CollectionsKt.last(this.offsets)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ CompositePosePath(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            List list3;
            void $this$scan$iv;
            Iterable iterable = list;
            Double initial$iv = 0.0;
            boolean $i$f$scan = false;
            void $this$runningFold$iv$iv = $this$scan$iv;
            boolean $i$f$runningFold = false;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
            if (estimatedSize$iv$iv == 0) {
                list3 = CollectionsKt.listOf((Object)initial$iv);
            } else {
                ArrayList<Double> arrayList;
                ArrayList<Double> $this$runningFold_u24lambda_u2420$iv$iv = arrayList = new ArrayList<Double>(estimatedSize$iv$iv + 1);
                boolean bl = false;
                $this$runningFold_u24lambda_u2420$iv$iv.add(initial$iv);
                ArrayList<Double> result$iv$iv = arrayList;
                Double accumulator$iv$iv = initial$iv;
                for (Object element$iv$iv : $this$runningFold$iv$iv) {
                    void path;
                    PosePath posePath = (PosePath)element$iv$iv;
                    double acc = ((Number)accumulator$iv$iv).doubleValue();
                    boolean bl2 = false;
                    accumulator$iv$iv = acc + path.length();
                    result$iv$iv.add(accumulator$iv$iv);
                }
                list3 = result$iv$iv;
            }
            list2 = list3;
        }
        this(list, list2);
    }

    @Override
    @NotNull
    public Pose2dDual<Arclength> get(double s, int n) {
        if (s > this.length) {
            return Pose2dDual.Companion.constant(((PosePath)CollectionsKt.last(this.paths)).end(1).value(), n);
        }
        for (Pair pair : CollectionsKt.reversed((Iterable)CollectionsKt.zip((Iterable)this.offsets, (Iterable)this.paths))) {
            double offset = ((Number)pair.component1()).doubleValue();
            PosePath path = (PosePath)pair.component2();
            if (!(s >= offset)) continue;
            return path.get(s - offset, n);
        }
        return Pose2dDual.Companion.constant(((PosePath)CollectionsKt.first(this.paths)).get(0.0, 1).value(), n);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    @NotNull
    public CompositePosePath plus(@NotNull PosePath other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof CompositePosePath ? new CompositePosePath(CollectionsKt.plus((Collection)this.paths, (Iterable)((CompositePosePath)other).paths), null, 2, null) : new CompositePosePath(CollectionsKt.plus((Collection)this.paths, (Object)other), null, 2, null);
    }

    @NotNull
    public final List<PosePath> component1() {
        return this.paths;
    }

    @NotNull
    public final List<Double> component2() {
        return this.offsets;
    }

    @NotNull
    public final CompositePosePath copy(@NotNull List<? extends PosePath> paths, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        return new CompositePosePath(paths, offsets);
    }

    public static /* synthetic */ CompositePosePath copy$default(CompositePosePath compositePosePath, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = compositePosePath.paths;
        }
        if ((n & 2) != 0) {
            list2 = compositePosePath.offsets;
        }
        return compositePosePath.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "CompositePosePath(paths=" + this.paths + ", offsets=" + this.offsets + ")";
    }

    public int hashCode() {
        int result = ((Object)this.paths).hashCode();
        result = result * 31 + ((Object)this.offsets).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositePosePath)) {
            return false;
        }
        CompositePosePath compositePosePath = (CompositePosePath)other;
        if (!Intrinsics.areEqual(this.paths, compositePosePath.paths)) {
            return false;
        }
        return Intrinsics.areEqual(this.offsets, compositePosePath.offsets);
    }

    @JvmOverloads
    public CompositePosePath(@NotNull List<? extends PosePath> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this(paths, null, 2, null);
    }
}

