/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.PositionPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\b\u0007\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0015\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u00c6\u0003J5\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/paths/CompositePositionPath;", "Param", "Lcom/acmerobotics/roadrunner/paths/PositionPath;", "paths", "", "offsets", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "param", "n", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nPositionPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionPaths.kt\ncom/acmerobotics/roadrunner/paths/CompositePositionPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n3067#2:254\n2967#2,3:255\n2970#2,6:259\n1#3:258\n*S KotlinDebug\n*F\n+ 1 PositionPaths.kt\ncom/acmerobotics/roadrunner/paths/CompositePositionPath\n*L\n214#1:254\n214#1:255,3\n214#1:259,6\n214#1:258\n*E\n"})
public final class CompositePositionPath<Param>
implements PositionPath<Param> {
    @JvmField
    @NotNull
    public final List<PositionPath<Param>> paths;
    @JvmField
    @NotNull
    public final List<Double> offsets;
    @JvmField
    public final double length;

    @JvmOverloads
    public CompositePositionPath(@NotNull List<? extends PositionPath<Param>> paths, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.paths = paths;
        this.offsets = offsets;
        this.length = ((Number)CollectionsKt.last(this.offsets)).doubleValue();
        if (!(!((Collection)this.paths).isEmpty())) {
            boolean bl = false;
            String string = "Composite path must contain at least one path";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ CompositePositionPath(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            List list3;
            void $this$scan$iv;
            Iterable iterable = list;
            Double initial$iv = 0.0;
            boolean $i$f$scan = false;
            void $this$runningFold$iv$iv = $this$scan$iv;
            boolean $i$f$runningFold = false;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
            if (estimatedSize$iv$iv == 0) {
                list3 = CollectionsKt.listOf((Object)initial$iv);
            } else {
                ArrayList<Double> arrayList;
                ArrayList<Double> $this$runningFold_u24lambda_u2420$iv$iv = arrayList = new ArrayList<Double>(estimatedSize$iv$iv + 1);
                boolean bl = false;
                $this$runningFold_u24lambda_u2420$iv$iv.add(initial$iv);
                ArrayList<Double> result$iv$iv = arrayList;
                Double accumulator$iv$iv = initial$iv;
                for (Object element$iv$iv : $this$runningFold$iv$iv) {
                    void path;
                    PositionPath positionPath = (PositionPath)element$iv$iv;
                    double acc = ((Number)accumulator$iv$iv).doubleValue();
                    boolean bl2 = false;
                    accumulator$iv$iv = acc + path.length();
                    result$iv$iv.add(accumulator$iv$iv);
                }
                list3 = result$iv$iv;
            }
            list2 = list3;
        }
        this(list, list2);
    }

    @Override
    @NotNull
    public Vector2dDual<Param> get(double param, int n) {
        if (param > this.length) {
            return Vector2dDual.Companion.constant(((PositionPath)CollectionsKt.last(this.paths)).end(1).value(), n);
        }
        for (Pair pair : CollectionsKt.reversed((Iterable)CollectionsKt.zip((Iterable)this.offsets, (Iterable)this.paths))) {
            double offset = ((Number)pair.component1()).doubleValue();
            PositionPath path = (PositionPath)pair.component2();
            if (!(param >= offset)) continue;
            return path.get(param - offset, n);
        }
        return Vector2dDual.Companion.constant(((PositionPath)CollectionsKt.first(this.paths)).get(0.0, 1).value(), n);
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final List<PositionPath<Param>> component1() {
        return this.paths;
    }

    @NotNull
    public final List<Double> component2() {
        return this.offsets;
    }

    @NotNull
    public final CompositePositionPath<Param> copy(@NotNull List<? extends PositionPath<Param>> paths, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        return new CompositePositionPath<Param>(paths, offsets);
    }

    public static /* synthetic */ CompositePositionPath copy$default(CompositePositionPath compositePositionPath, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = compositePositionPath.paths;
        }
        if ((n & 2) != 0) {
            list2 = compositePositionPath.offsets;
        }
        return compositePositionPath.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "CompositePositionPath(paths=" + this.paths + ", offsets=" + this.offsets + ")";
    }

    public int hashCode() {
        int result = ((Object)this.paths).hashCode();
        result = result * 31 + ((Object)this.offsets).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositePositionPath)) {
            return false;
        }
        CompositePositionPath compositePositionPath = (CompositePositionPath)other;
        if (!Intrinsics.areEqual(this.paths, compositePositionPath.paths)) {
            return false;
        }
        return Intrinsics.areEqual(this.offsets, compositePositionPath.offsets);
    }

    @JvmOverloads
    public CompositePositionPath(@NotNull List<? extends PositionPath<Param>> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this(paths, null, 2, null);
    }
}

