/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.PositionPath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u000bJ\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/acmerobotics/roadrunner/paths/Line;", "Lcom/acmerobotics/roadrunner/paths/PositionPath;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "begin", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "dir", "length", "", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;D)V", "end", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "param", "n", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
public final class Line
implements PositionPath<Arclength> {
    @JvmField
    @NotNull
    public final Vector2d begin;
    @JvmField
    @NotNull
    public final Vector2d dir;
    @JvmField
    public final double length;

    public Line(@NotNull Vector2d begin, @NotNull Vector2d dir, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.begin = begin;
        this.dir = dir;
        this.length = length;
    }

    /*
     * WARNING - void declaration
     */
    public Line(@NotNull Vector2d begin, @NotNull Vector2d end) {
        void diff;
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Vector2d vector2d = end.minus(begin);
        Vector2d vector2d2 = begin;
        Line line = this;
        boolean bl = false;
        double norm = diff.norm();
        Vector2d vector2d3 = norm < 1.0E-6 ? new Vector2d(1.0, 0.0) : diff.div(norm);
        line(vector2d2, vector2d3, end.minus(begin).norm());
    }

    @Override
    @NotNull
    public Vector2dDual<Arclength> get(double param, int n) {
        return DualNum.Companion.variable(param, n).times(this.dir).plus(this.begin);
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final Vector2d component1() {
        return this.begin;
    }

    @NotNull
    public final Vector2d component2() {
        return this.dir;
    }

    public final double component3() {
        return this.length;
    }

    @NotNull
    public final Line copy(@NotNull Vector2d begin, @NotNull Vector2d dir, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return new Line(begin, dir, length);
    }

    public static /* synthetic */ Line copy$default(Line line, Vector2d vector2d, Vector2d vector2d2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2d = line.begin;
        }
        if ((n & 2) != 0) {
            vector2d2 = line.dir;
        }
        if ((n & 4) != 0) {
            d = line.length;
        }
        return line.copy(vector2d, vector2d2, d);
    }

    @NotNull
    public String toString() {
        return "Line(begin=" + this.begin + ", dir=" + this.dir + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = this.begin.hashCode();
        result = result * 31 + this.dir.hashCode();
        result = result * 31 + Double.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        Line line = (Line)other;
        if (!Intrinsics.areEqual((Object)this.begin, (Object)line.begin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dir, (Object)line.dir)) {
            return false;
        }
        return Double.compare(this.length, line.length) == 0;
    }
}

