/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.paths.PosePath;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/acmerobotics/roadrunner/paths/OffsetPosePath;", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "path", "offsets", "", "", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PosePath;Ljava/util/List;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "s", "n", "", "length", "core"})
public final class OffsetPosePath
implements PosePath {
    @JvmField
    @NotNull
    public final PosePath path;
    @JvmField
    @NotNull
    public final List<Double> offsets;

    public OffsetPosePath(@NotNull PosePath path, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.path = path;
        this.offsets = offsets;
        if (!(this.offsets.size() == 2)) {
            boolean bl = false;
            String string = "offsets.size (" + this.offsets.size() + ") != 2";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ OffsetPosePath(PosePath posePath, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Object[] objectArray = new Double[]{0.0, posePath.length()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this(posePath, list);
    }

    @Override
    @NotNull
    public Pose2dDual<Arclength> get(double s, int n) {
        double offset = ((Number)this.offsets.get(0)).doubleValue();
        double length = ((Number)this.offsets.get(1)).doubleValue() - ((Number)this.offsets.get(0)).doubleValue();
        return this.path.get(s * length + offset, n);
    }

    @Override
    public double length() {
        return ((Number)this.offsets.get(1)).doubleValue() - ((Number)this.offsets.get(0)).doubleValue();
    }
}

