/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.ConstantHeadingPath;
import com.acmerobotics.roadrunner.paths.HeadingPosePath;
import com.acmerobotics.roadrunner.paths.LinearHeadingPath;
import com.acmerobotics.roadrunner.paths.PositionPaths;
import com.acmerobotics.roadrunner.paths.SplineHeadingPath;
import com.acmerobotics.roadrunner.paths.TangentPath;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6\u0002J\b\u0010\t\u001a\u00020\u0006H&J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcom/acmerobotics/roadrunner/paths/PositionPath;", "Param", "", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "param", "", "n", "", "length", "begin", "end", "project", "query", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "init", "withTangentHeading", "Lcom/acmerobotics/roadrunner/paths/TangentPath;", "withConstantHeading", "Lcom/acmerobotics/roadrunner/paths/HeadingPosePath;", "heading", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "withLinearHeading", "startHeading", "endHeading", "withSplineHeading", "core"})
@SourceDebugExtension(value={"SMAP\nPositionPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionPaths.kt\ncom/acmerobotics/roadrunner/paths/PositionPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1803#2,3:254\n*S KotlinDebug\n*F\n+ 1 PositionPaths.kt\ncom/acmerobotics/roadrunner/paths/PositionPath\n*L\n38#1:254,3\n*E\n"})
public interface PositionPath<Param> {
    @NotNull
    public Vector2dDual<Param> get(double var1, int var3);

    public double length();

    @NotNull
    default public Vector2dDual<Param> begin(int n) {
        return this.get(0.0, n);
    }

    @NotNull
    default public Vector2dDual<Param> end(int n) {
        return this.get(this.length(), n);
    }

    /*
     * WARNING - void declaration
     */
    default public double project(@NotNull Vector2d query, double init) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Iterable iterable = (Iterable)new IntRange(1, 10);
        double initial$iv = init;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            double s = accumulator$iv;
            boolean bl = false;
            Vector2dDual<Param> guess = this.get(s, 3);
            double ds = query.minus(guess.value()).dot(guess.drop(1).value());
            accumulator$iv = Math.clamp(s + ds, 0.0, this.length());
        }
        return accumulator$iv;
    }

    public static /* synthetic */ double project$default(PositionPath positionPath, Vector2d vector2d, double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: project");
        }
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return positionPath.project(vector2d, d);
    }

    @NotNull
    default public TangentPath withTangentHeading() {
        return new TangentPath(PositionPaths.access$wrtArclength(this), 0.0);
    }

    @NotNull
    default public HeadingPosePath withConstantHeading(@NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new ConstantHeadingPath(heading, it.length()));
    }

    @NotNull
    default public HeadingPosePath withConstantHeading(double heading) {
        return this.withConstantHeading(PositionPaths.toRotation(heading));
    }

    @NotNull
    default public HeadingPosePath withLinearHeading(@NotNull Rotation2d startHeading, @NotNull Rotation2d endHeading) {
        Intrinsics.checkNotNullParameter((Object)startHeading, (String)"startHeading");
        Intrinsics.checkNotNullParameter((Object)endHeading, (String)"endHeading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new LinearHeadingPath(startHeading, endHeading.minus(startHeading), it.length()));
    }

    @NotNull
    default public HeadingPosePath withLinearHeading(double startHeading, double endHeading) {
        return this.withLinearHeading(PositionPaths.toRotation(startHeading), PositionPaths.toRotation(endHeading));
    }

    @NotNull
    default public HeadingPosePath withSplineHeading(@NotNull Rotation2d startHeading, @NotNull Rotation2d endHeading) {
        Intrinsics.checkNotNullParameter((Object)startHeading, (String)"startHeading");
        Intrinsics.checkNotNullParameter((Object)endHeading, (String)"endHeading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new SplineHeadingPath(PositionPaths.dual(startHeading), PositionPaths.dual(PositionPaths.toRotation(endHeading.minus(startHeading))), it.length()));
    }

    @NotNull
    default public HeadingPosePath withSplineHeading(double startHeading, double endHeading) {
        return this.withSplineHeading(PositionPaths.toRotation(startHeading), PositionPaths.toRotation(endHeading));
    }
}

