/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual;
import com.acmerobotics.roadrunner.paths.HeadingPath;
import com.acmerobotics.roadrunner.paths.QuinticSpline1d;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rJ\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/acmerobotics/roadrunner/paths/SplineHeadingPath;", "Lcom/acmerobotics/roadrunner/paths/HeadingPath;", "begin", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "spline", "Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;", "length", "", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Rotation2d;Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;D)V", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "end", "(Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;D)V", "get", "s", "n", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
public final class SplineHeadingPath
implements HeadingPath {
    @JvmField
    @NotNull
    public final Rotation2d begin;
    @JvmField
    @NotNull
    public final QuinticSpline1d spline;
    @JvmField
    public final double length;

    public SplineHeadingPath(@NotNull Rotation2d begin, @NotNull QuinticSpline1d spline, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        this.begin = begin;
        this.spline = spline;
        this.length = length;
    }

    public SplineHeadingPath(@NotNull Rotation2dDual<Arclength> begin, @NotNull Rotation2dDual<Arclength> end, double length) {
        Intrinsics.checkNotNullParameter(begin, (String)"begin");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        if (!(begin.size() >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit unit = Unit.INSTANCE;
        Rotation2d rotation2d = begin.value();
        SplineHeadingPath splineHeadingPath = this;
        boolean bl = false;
        if (!(end.size() >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit it = Unit.INSTANCE;
        boolean bl2 = false;
        DualNum s = DualNum.Companion.variable(1.0, 3).times(length);
        boolean bl3 = false;
        QuinticSpline1d quinticSpline1d = new QuinticSpline1d(DualNum.Companion.cons(0.0, begin.velocity()).reparam(s), DualNum.Companion.cons(end.value().minus(begin.value()), end.velocity()).reparam(s));
        splineHeadingPath(rotation2d, quinticSpline1d, length);
    }

    @Override
    @NotNull
    public Rotation2dDual<Arclength> get(double s, int n) {
        return Rotation2dDual.Companion.exp(this.spline.get(s / this.length, n).reparam(DualNum.Companion.variable(s, n).div(this.length))).times(this.begin);
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final Rotation2d component1() {
        return this.begin;
    }

    @NotNull
    public final QuinticSpline1d component2() {
        return this.spline;
    }

    public final double component3() {
        return this.length;
    }

    @NotNull
    public final SplineHeadingPath copy(@NotNull Rotation2d begin, @NotNull QuinticSpline1d spline, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        return new SplineHeadingPath(begin, spline, length);
    }

    public static /* synthetic */ SplineHeadingPath copy$default(SplineHeadingPath splineHeadingPath, Rotation2d rotation2d, QuinticSpline1d quinticSpline1d, double d, int n, Object object) {
        if ((n & 1) != 0) {
            rotation2d = splineHeadingPath.begin;
        }
        if ((n & 2) != 0) {
            quinticSpline1d = splineHeadingPath.spline;
        }
        if ((n & 4) != 0) {
            d = splineHeadingPath.length;
        }
        return splineHeadingPath.copy(rotation2d, quinticSpline1d, d);
    }

    @NotNull
    public String toString() {
        return "SplineHeadingPath(begin=" + this.begin + ", spline=" + this.spline + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = this.begin.hashCode();
        result = result * 31 + this.spline.hashCode();
        result = result * 31 + Double.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplineHeadingPath)) {
            return false;
        }
        SplineHeadingPath splineHeadingPath = (SplineHeadingPath)other;
        if (!Intrinsics.areEqual((Object)this.begin, (Object)splineHeadingPath.begin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spline, (Object)splineHeadingPath.spline)) {
            return false;
        }
        return Double.compare(this.length, splineHeadingPath.length) == 0;
    }
}

