/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.paths.PositionPath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/paths/TangentPath;", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "path", "Lcom/acmerobotics/roadrunner/paths/PositionPath;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "offset", "", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PositionPath;D)V", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "s", "n", "", "length", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
public final class TangentPath
implements PosePath {
    @JvmField
    @NotNull
    public final PositionPath<Arclength> path;
    @JvmField
    public final double offset;

    public TangentPath(@NotNull PositionPath<Arclength> path, double offset) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.path = path;
        this.offset = offset;
    }

    @Override
    @NotNull
    public Pose2dDual<Arclength> get(double s, int n) {
        Vector2dDual<Arclength> it = this.path.get(s, n + 1);
        boolean bl = false;
        return new Pose2dDual<Arclength>(it, it.drop(1).angleCast().plus(this.offset));
    }

    @Override
    public double length() {
        return this.path.length();
    }

    @NotNull
    public final PositionPath<Arclength> component1() {
        return this.path;
    }

    public final double component2() {
        return this.offset;
    }

    @NotNull
    public final TangentPath copy(@NotNull PositionPath<Arclength> path, double offset) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new TangentPath(path, offset);
    }

    public static /* synthetic */ TangentPath copy$default(TangentPath tangentPath, PositionPath positionPath, double d, int n, Object object) {
        if ((n & 1) != 0) {
            positionPath = tangentPath.path;
        }
        if ((n & 2) != 0) {
            d = tangentPath.offset;
        }
        return tangentPath.copy(positionPath, d);
    }

    @NotNull
    public String toString() {
        return "TangentPath(path=" + this.path + ", offset=" + this.offset + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + Double.hashCode(this.offset);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TangentPath)) {
            return false;
        }
        TangentPath tangentPath = (TangentPath)other;
        if (!Intrinsics.areEqual(this.path, tangentPath.path)) {
            return false;
        }
        return Double.compare(this.offset, tangentPath.offset) == 0;
    }
}

