/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile;
import com.acmerobotics.roadrunner.profiles.Profile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006J\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0096\u0003R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/acmerobotics/roadrunner/profiles/CancelableProfile;", "Lcom/acmerobotics/roadrunner/profiles/Profile;", "baseProfile", "Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "disps", "", "", "minAccels", "<init>", "(Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;Ljava/util/List;Ljava/util/List;)V", "cancel", "x", "get", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "core"})
public final class CancelableProfile
implements Profile {
    @JvmField
    @NotNull
    public final DisplacementProfile baseProfile;
    @JvmField
    @NotNull
    public final List<Double> disps;
    @JvmField
    @NotNull
    public final List<Double> minAccels;

    public CancelableProfile(@NotNull DisplacementProfile baseProfile, @NotNull List<Double> disps, @NotNull List<Double> minAccels) {
        Intrinsics.checkNotNullParameter((Object)baseProfile, (String)"baseProfile");
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(minAccels, (String)"minAccels");
        this.baseProfile = baseProfile;
        this.disps = disps;
        this.minAccels = minAccels;
    }

    @NotNull
    public final DisplacementProfile cancel(double x) {
        int insIndex;
        int beginIndex;
        Object[] objectArray = new Double[]{0.0};
        List newDisps = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{this.baseProfile.get(x).get(1)};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray2);
        List accels = new ArrayList();
        int rawIndex = CollectionsKt.binarySearch$default(this.disps, (Comparable)Double.valueOf(x), (int)0, (int)0, (int)6, null);
        int n = beginIndex = rawIndex >= 0 ? rawIndex : (insIndex = -(rawIndex + 1));
        if (beginIndex == 0) {
            return new DisplacementProfile(CollectionsKt.listOf((Object)0.0), CollectionsKt.listOf((Object)CollectionsKt.first((List)vels)), CollectionsKt.emptyList());
        }
        double targetVel = ((Number)CollectionsKt.last(this.baseProfile.vels)).doubleValue();
        int index = beginIndex;
        int n2 = CollectionsKt.getLastIndex(this.disps);
        if (index <= n2) {
            while (true) {
                double v = ((Number)CollectionsKt.last((List)vels)).doubleValue();
                double a = ((Number)this.minAccels.get(index - 1)).doubleValue();
                double targetDisp = ((Number)CollectionsKt.last((List)newDisps)).doubleValue() + (targetVel * targetVel - v * v) / ((double)2 * a);
                if (!(x + targetDisp > ((Number)this.disps.get(index)).doubleValue())) {
                    newDisps.add(targetDisp);
                    vels.add(targetVel);
                    accels.add(a);
                    break;
                }
                newDisps.add(((Number)this.disps.get(index)).doubleValue() - x);
                vels.add(Math.sqrt(v * v + (double)2 * a * (((Number)this.disps.get(index)).doubleValue() - ((Number)this.disps.get(index - 1)).doubleValue())));
                accels.add(a);
                if (index == n2) break;
                ++index;
            }
        }
        return new DisplacementProfile(newDisps, vels, accels);
    }

    @Override
    @NotNull
    public DualNum<Time> get(double x) {
        return this.baseProfile.get(x);
    }
}

