/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.profiles.Profile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0096\u0002J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "Lcom/acmerobotics/roadrunner/profiles/Profile;", "disps", "", "", "vels", "accels", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "x", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
public final class DisplacementProfile
implements Profile {
    @JvmField
    @NotNull
    public final List<Double> disps;
    @JvmField
    @NotNull
    public final List<Double> vels;
    @JvmField
    @NotNull
    public final List<Double> accels;
    @JvmField
    public final double length;

    public DisplacementProfile(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        this.disps = disps;
        this.vels = vels;
        this.accels = accels;
        this.length = ((Number)CollectionsKt.last(this.disps)).doubleValue();
        if (!(this.disps.size() == this.vels.size())) {
            boolean $i$a$-require-DisplacementProfile$32 = false;
            String $i$a$-require-DisplacementProfile$32 = "disps.size() (" + this.disps.size() + ") != vels.size() (" + this.vels.size() + ")";
            throw new IllegalArgumentException($i$a$-require-DisplacementProfile$32.toString());
        }
        if (!(this.disps.size() == this.accels.size() + 1)) {
            boolean bl = false;
            String string = "disps.size() (" + this.disps.size() + ") != accels.size() + 1 (" + (this.accels.size() + 1) + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public DualNum<Time> get(double x) {
        DualNum dualNum;
        int index = CollectionsKt.binarySearch$default(this.disps, (Comparable)Double.valueOf(x), (int)0, (int)0, (int)6, null);
        if (index >= CollectionsKt.getLastIndex(this.disps)) {
            double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), 0.0};
            DualNum dualNum2 = new DualNum(dArray);
            dualNum = dualNum2;
        } else if (index >= 0) {
            double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), ((Number)this.accels.get(index)).doubleValue()};
            DualNum dualNum3 = new DualNum(dArray);
            dualNum = dualNum3;
        } else {
            int insIndex = -(index + 1);
            if (insIndex <= 0) {
                double[] dArray = new double[]{x, ((Number)CollectionsKt.first(this.vels)).doubleValue(), 0.0};
                DualNum dualNum4 = new DualNum(dArray);
                dualNum = dualNum4;
            } else if (insIndex >= this.disps.size()) {
                double[] dArray = new double[]{x, ((Number)CollectionsKt.last(this.vels)).doubleValue(), 0.0};
                DualNum dualNum5 = new DualNum(dArray);
                dualNum = dualNum5;
            } else {
                double dx = x - ((Number)this.disps.get(insIndex - 1)).doubleValue();
                double v0 = ((Number)this.vels.get(insIndex - 1)).doubleValue();
                double a = ((Number)this.accels.get(insIndex - 1)).doubleValue();
                double[] dArray = new double[]{x, Math.sqrt(v0 * v0 + (double)2 * a * dx), a};
                DualNum dualNum6 = new DualNum(dArray);
                dualNum = dualNum6;
            }
        }
        return dualNum;
    }

    @NotNull
    public final List<Double> component1() {
        return this.disps;
    }

    @NotNull
    public final List<Double> component2() {
        return this.vels;
    }

    @NotNull
    public final List<Double> component3() {
        return this.accels;
    }

    @NotNull
    public final DisplacementProfile copy(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        return new DisplacementProfile(disps, vels, accels);
    }

    public static /* synthetic */ DisplacementProfile copy$default(DisplacementProfile displacementProfile, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = displacementProfile.disps;
        }
        if ((n & 2) != 0) {
            list2 = displacementProfile.vels;
        }
        if ((n & 4) != 0) {
            list3 = displacementProfile.accels;
        }
        return displacementProfile.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "DisplacementProfile(disps=" + this.disps + ", vels=" + this.vels + ", accels=" + this.accels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.disps).hashCode();
        result = result * 31 + ((Object)this.vels).hashCode();
        result = result * 31 + ((Object)this.accels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplacementProfile)) {
            return false;
        }
        DisplacementProfile displacementProfile = (DisplacementProfile)other;
        if (!Intrinsics.areEqual(this.disps, displacementProfile.disps)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.vels, displacementProfile.vels)) {
            return false;
        }
        return Intrinsics.areEqual(this.accels, displacementProfile.accels);
    }
}

