/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.paths.CompositePosePath;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile;
import com.acmerobotics.roadrunner.profiles.Profiles;
import com.acmerobotics.roadrunner.trajectories.DisplacementTrajectory;
import com.acmerobotics.roadrunner.trajectories.Trajectory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\u0004\b\u0006\u0010\nB\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\fB%\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u000b\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0006\u0010\rJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/CompositeTrajectory;", "Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;", "trajectories", "", "offsets", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "", "Lcom/acmerobotics/roadrunner/trajectories/Trajectory;", "(Ljava/util/Collection;)V", "", "([Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;)V", "([Lcom/acmerobotics/roadrunner/trajectories/Trajectory;)V", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "s", "core"})
@SourceDebugExtension(value={"SMAP\nTrajectories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trajectories.kt\ncom/acmerobotics/roadrunner/trajectories/CompositeTrajectory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n1563#2:152\n1634#2,3:153\n1563#2:156\n1634#2,3:157\n2783#2,7:160\n3067#2:167\n2967#2,3:168\n2970#2,6:172\n1563#2:178\n1634#2,3:179\n1#3:171\n11228#4:182\n11563#4,3:183\n*S KotlinDebug\n*F\n+ 1 Trajectories.kt\ncom/acmerobotics/roadrunner/trajectories/CompositeTrajectory\n*L\n115#1:152\n115#1:153,3\n116#1:156\n116#1:157,3\n116#1:160,7\n113#1:167\n113#1:168,3\n113#1:172,6\n119#1:178\n119#1:179,3\n113#1:171\n121#1:182\n121#1:183,3\n*E\n"})
public final class CompositeTrajectory
extends DisplacementTrajectory {
    @JvmField
    @NotNull
    public final List<DisplacementTrajectory> trajectories;
    @JvmField
    @NotNull
    public final List<Double> offsets;
    @JvmField
    public final double length;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CompositeTrajectory(@NotNull List<? extends DisplacementTrajectory> trajectories, @NotNull List<Double> offsets) {
        void $this$reduce$iv;
        Collection<Object> collection;
        DisplacementTrajectory it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(trajectories, (String)"trajectories");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        Iterable iterable = trajectories;
        CompositeTrajectory compositeTrajectory = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DisplacementTrajectory displacementTrajectory = (DisplacementTrajectory)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.path);
        }
        List<Double> list = offsets;
        List list2 = (List)destination$iv$iv;
        $this$map$iv = trajectories;
        PosePath posePath = new CompositePosePath(list2, list);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DisplacementTrajectory)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.profile);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void profile;
            DisplacementProfile $i$f$mapTo2 = (DisplacementProfile)iterator$iv.next();
            DisplacementProfile acc = (DisplacementProfile)accumulator$iv;
            boolean bl = false;
            accumulator$iv = Profiles.plus(acc, (DisplacementProfile)profile);
        }
        collection = accumulator$iv;
        super(posePath, (DisplacementProfile)((Object)collection));
        this.trajectories = trajectories;
        this.offsets = offsets;
        this.length = ((Number)CollectionsKt.last(this.offsets)).doubleValue();
        if (!(this.trajectories.size() + 1 == this.offsets.size())) {
            boolean bl = false;
            String string = "trajectories.size (" + this.trajectories.size() + ") + 1 != offsets.size (" + this.offsets.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ CompositeTrajectory(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            List list3;
            void $this$scan$iv;
            Iterable iterable = list;
            Double initial$iv = 0.0;
            boolean $i$f$scan = false;
            void $this$runningFold$iv$iv = $this$scan$iv;
            boolean $i$f$runningFold = false;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
            if (estimatedSize$iv$iv == 0) {
                list3 = CollectionsKt.listOf((Object)initial$iv);
            } else {
                ArrayList<Double> arrayList;
                ArrayList<Double> $this$runningFold_u24lambda_u2420$iv$iv = arrayList = new ArrayList<Double>(estimatedSize$iv$iv + 1);
                boolean bl = false;
                $this$runningFold_u24lambda_u2420$iv$iv.add(initial$iv);
                ArrayList<Double> result$iv$iv = arrayList;
                Double accumulator$iv$iv = initial$iv;
                for (Object element$iv$iv : $this$runningFold$iv$iv) {
                    void t;
                    DisplacementTrajectory displacementTrajectory = (DisplacementTrajectory)element$iv$iv;
                    double acc = ((Number)accumulator$iv$iv).doubleValue();
                    boolean bl2 = false;
                    accumulator$iv$iv = acc + t.length();
                    result$iv$iv.add(accumulator$iv$iv);
                }
                list3 = result$iv$iv;
            }
            list2 = list3;
        }
        this(list, list2);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeTrajectory(@NotNull Collection<? extends Trajectory<?>> trajectories) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(trajectories, (String)"trajectories");
        Iterable iterable = trajectories;
        CompositeTrajectory compositeTrajectory = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Trajectory trajectory = (Trajectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.wrtDisp());
        }
        compositeTrajectory((List)destination$iv$iv, null, 2, null);
    }

    public CompositeTrajectory(DisplacementTrajectory ... trajectories) {
        Intrinsics.checkNotNullParameter((Object)trajectories, (String)"trajectories");
        this(ArraysKt.toList((Object[])trajectories), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeTrajectory(Trajectory<?> ... trajectories) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(trajectories, (String)"trajectories");
        Trajectory<?>[] trajectoryArray = trajectories;
        CompositeTrajectory compositeTrajectory = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.wrtDisp());
        }
        compositeTrajectory((List)destination$iv$iv, null, 2, null);
    }

    @Override
    @NotNull
    public Pose2dDual<Time> get(double s) {
        if (s > this.length) {
            return Pose2dDual.Companion.constant(((DisplacementTrajectory)CollectionsKt.last(this.trajectories)).path.end(1).value(), 3);
        }
        for (Pair pair : CollectionsKt.reversed((Iterable)CollectionsKt.zip((Iterable)this.offsets, (Iterable)this.trajectories))) {
            double offset = ((Number)pair.component1()).doubleValue();
            DisplacementTrajectory traj = (DisplacementTrajectory)pair.component2();
            if (!(s >= offset)) continue;
            return traj.get(s - offset);
        }
        return ((DisplacementTrajectory)CollectionsKt.first(this.trajectories)).get(0.0);
    }

    @Override
    public double length() {
        return this.length;
    }

    @JvmOverloads
    public CompositeTrajectory(@NotNull List<? extends DisplacementTrajectory> trajectories) {
        Intrinsics.checkNotNullParameter(trajectories, (String)"trajectories");
        this(trajectories, null, 2, null);
    }
}

