/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile;
import com.acmerobotics.roadrunner.trajectories.CancelableTrajectory;
import com.acmerobotics.roadrunner.trajectories.TimeTrajectory;
import com.acmerobotics.roadrunner.trajectories.Trajectory;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\f\u001a\u00020\u0000H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;", "Lcom/acmerobotics/roadrunner/trajectories/Trajectory;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "profile", "Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PosePath;Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;)V", "t", "Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;", "(Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;)V", "wrtDisp", "wrtTime", "Lcom/acmerobotics/roadrunner/trajectories/TimeTrajectory;", "length", "", "project", "query", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "init", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "s", "core"})
public class DisplacementTrajectory
implements Trajectory<Arclength> {
    @JvmField
    @NotNull
    public final PosePath path;
    @JvmField
    @NotNull
    public final DisplacementProfile profile;

    public DisplacementTrajectory(@NotNull PosePath path, @NotNull DisplacementProfile profile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.path = path;
        this.profile = profile;
    }

    public DisplacementTrajectory(@NotNull CancelableTrajectory t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this(t.path, t.cProfile.baseProfile);
    }

    @Override
    @NotNull
    public DisplacementTrajectory wrtDisp() {
        return this;
    }

    @Override
    @NotNull
    public TimeTrajectory wrtTime() {
        return new TimeTrajectory(this);
    }

    @Override
    public double length() {
        return this.path.length();
    }

    @Override
    public double project(@NotNull Vector2d query, double init) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.path.project(query, init);
    }

    @Override
    @NotNull
    public Pose2dDual<Time> get(double s) {
        return this.path.get(s, 3).reparam(this.profile.get(s));
    }
}

