/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.TimeProfile;
import com.acmerobotics.roadrunner.trajectories.CancelableTrajectory;
import com.acmerobotics.roadrunner.trajectories.DisplacementTrajectory;
import com.acmerobotics.roadrunner.trajectories.Trajectory;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\t\u001a\u00020\u000fH\u0096\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/TimeTrajectory;", "Lcom/acmerobotics/roadrunner/trajectories/Trajectory;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "profile", "Lcom/acmerobotics/roadrunner/profiles/TimeProfile;", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PosePath;Lcom/acmerobotics/roadrunner/profiles/TimeProfile;)V", "t", "Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;", "(Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;)V", "Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;", "(Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;)V", "duration", "", "wrtDisp", "wrtTime", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "project", "query", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "init", "core"})
public final class TimeTrajectory
implements Trajectory<Time> {
    @JvmField
    @NotNull
    public final PosePath path;
    @JvmField
    @NotNull
    public final TimeProfile profile;
    @JvmField
    public final double duration;

    public TimeTrajectory(@NotNull PosePath path, @NotNull TimeProfile profile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.path = path;
        this.profile = profile;
        this.duration = this.profile.duration;
    }

    public TimeTrajectory(@NotNull CancelableTrajectory t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this(t.path, new TimeProfile(t.cProfile.baseProfile, null, 2, null));
    }

    public TimeTrajectory(@NotNull DisplacementTrajectory t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this(t.path, new TimeProfile(t.profile, null, 2, null));
    }

    @Override
    @NotNull
    public DisplacementTrajectory wrtDisp() {
        return new DisplacementTrajectory(this.path, this.profile.dispProfile);
    }

    @Override
    @NotNull
    public TimeTrajectory wrtTime() {
        return this;
    }

    @Override
    public double length() {
        return this.path.length();
    }

    @Override
    @NotNull
    public Pose2dDual<Time> get(double t) {
        DualNum<Time> s = this.profile.get(t);
        return this.path.get(s.value(), 3).reparam(s);
    }

    @Override
    public double project(@NotNull Vector2d query, double init) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.path.project(query, init);
    }
}

