/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.control.LQRControllerKt;
import com.acmerobotics.roadrunner.control.RobotPosVelController;
import com.acmerobotics.roadrunner.geometry.Acceleration2d;
import com.acmerobotics.roadrunner.geometry.MatricesKt;
import com.acmerobotics.roadrunner.geometry.Matrix;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Twist2d;
import com.acmerobotics.roadrunner.geometry.Twist2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B[\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eBG\b\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0010\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u0017J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010J\u001a\u0010\u001c\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u001f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0 J,\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/acmerobotics/roadrunner/control/LQRController;", "Lcom/acmerobotics/roadrunner/control/RobotPosVelController;", "qX", "", "qY", "qHeading", "qVx", "qVy", "qOmega", "rAx", "rAy", "rAlpha", "dt", "<init>", "(DDDDDDDDDD)V", "A", "Lcom/acmerobotics/roadrunner/geometry/Matrix;", "B", "Q", "R", "maxIter", "", "epsilon", "(Lcom/acmerobotics/roadrunner/geometry/Matrix;Lcom/acmerobotics/roadrunner/geometry/Matrix;Lcom/acmerobotics/roadrunner/geometry/Matrix;Lcom/acmerobotics/roadrunner/geometry/Matrix;DID)V", "k", "Lorg/ejml/simple/SimpleMatrix;", "start", "Lkotlin/time/ComparableTimeMark;", "update", "error", "Lcom/acmerobotics/roadrunner/geometry/Acceleration2d;", "Param", "Lcom/acmerobotics/roadrunner/geometry/Twist2dDual;", "compute", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "targetPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "actualPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "actualVelActual", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "core"})
@SourceDebugExtension(value={"SMAP\nLQRController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LQRController.kt\ncom/acmerobotics/roadrunner/control/LQRController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
public final class LQRController
implements RobotPosVelController {
    @NotNull
    private final SimpleMatrix k;
    private final double dt;
    @NotNull
    private final ComparableTimeMark start;

    public LQRController(double qX, double qY, double qHeading, double qVx, double qVy, double qOmega, double rAx, double rAy, double rAlpha, double dt) {
        SimpleMatrix K;
        this.start = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        SimpleMatrix A_cont = new SimpleMatrix(6, 6);
        A_cont.set(0, 3, 1.0);
        A_cont.set(1, 4, 1.0);
        A_cont.set(2, 5, 1.0);
        SimpleMatrix B_cont = new SimpleMatrix(6, 3);
        B_cont.set(3, 0, 1.0);
        B_cont.set(4, 1, 1.0);
        B_cont.set(5, 2, 1.0);
        Pair pair = LQRControllerKt.discretizeSystem$default(A_cont, B_cont, dt, 0, 8, null);
        SimpleMatrix Ad = (SimpleMatrix)pair.component1();
        SimpleMatrix Bd = (SimpleMatrix)pair.component2();
        double[] dArray = new double[]{qX, qY, qHeading, qVx, qVy, qOmega};
        Matrix Q = MatricesKt.makeBrysonMatrix(dArray);
        double[] dArray2 = new double[]{rAx, rAy, rAlpha};
        Matrix R = MatricesKt.makeBrysonMatrix(dArray2);
        this.k = K = (SimpleMatrix)LQRControllerKt.computeLQRGain$default(Ad, Bd, Q.getSimple$core(), R.getSimple$core(), 0, 0.0, 48, null).component2();
        this.dt = dt;
    }

    public /* synthetic */ LQRController(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            d10 = 0.0303;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R, double dt, int maxIter, double epsilon) {
        SimpleMatrix K;
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this.start = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        if (!(dt > 0.0)) {
            boolean $i$a$-require-LQRController$42 = false;
            String $i$a$-require-LQRController$42 = "Time step (dt) must be positive";
            throw new IllegalArgumentException($i$a$-require-LQRController$42.toString());
        }
        if (!(A.getNumRows() == A.getNumCols() && A.getNumRows() == Q.getNumRows() && Q.getNumRows() == Q.getNumCols())) {
            boolean $i$a$-require-LQRController$52 = false;
            String $i$a$-require-LQRController$52 = "A and Q must be square and match dimensions.";
            throw new IllegalArgumentException($i$a$-require-LQRController$52.toString());
        }
        if (!(B.getNumRows() == A.getNumRows() && B.getNumCols() == R.getNumRows() && R.getNumRows() == R.getNumCols())) {
            boolean $i$a$-require-LQRController$62 = false;
            String $i$a$-require-LQRController$62 = "B and R must have compatible dimensions with A and each other.";
            throw new IllegalArgumentException($i$a$-require-LQRController$62.toString());
        }
        Pair pair = LQRControllerKt.discretizeSystem$default(A.getSimple$core(), B.getSimple$core(), dt, 0, 8, null);
        SimpleMatrix Ad = (SimpleMatrix)pair.component1();
        SimpleMatrix Bd = (SimpleMatrix)pair.component2();
        this.k = K = (SimpleMatrix)LQRControllerKt.computeLQRGain$default(Ad, Bd, Q.getSimple$core(), R.getSimple$core(), 0, 0.0, 48, null).component2();
        this.dt = dt;
    }

    public /* synthetic */ LQRController(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4, double d, int n, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            d = 0.0303;
        }
        if ((n2 & 0x20) != 0) {
            n = 100;
        }
        if ((n2 & 0x40) != 0) {
            d2 = 1.0E-6;
        }
        this(matrix, matrix2, matrix3, matrix4, d, n, d2);
    }

    @NotNull
    public final Matrix update(@NotNull Matrix error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!(error.getNumCols() == this.k.getNumCols())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Matrix(MatricesKt.times(MatricesKt.unaryMinus(this.k), error.getSimple$core()));
    }

    @NotNull
    public final <Param> Acceleration2d update(@NotNull Twist2dDual<Param> error) {
        Intrinsics.checkNotNullParameter(error, (String)"error");
        if (!(LQRControllerKt.size(error) >= 2)) {
            boolean $i$a$-require-LQRController$update$22 = false;
            String $i$a$-require-LQRController$update$22 = "Position and velocity errors must be provided";
            throw new IllegalArgumentException($i$a$-require-LQRController$update$22.toString());
        }
        Twist2d posError = error.value();
        PoseVelocity2d velError = error.velocity().value();
        double[] dArray = new double[]{posError.line.x, posError.line.y, posError.angle, velError.linearVel.x, velError.linearVel.y, velError.angVel};
        Matrix input = new Matrix(dArray, null, 2, null);
        Matrix output = this.update(input);
        return new Acceleration2d(new Vector2d(output.get(0, 0), output.get(1, 0)), output.get(2, 0));
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        Twist2d posError = targetPose.value().minus(actualPose);
        PoseVelocity2d it = targetPose.velocity().value().minus(actualVelActual);
        boolean bl = false;
        Twist2d velError = new Twist2d(it.linearVel, it.angVel);
        Acceleration2d acc = this.update(LQRControllerKt.concat(posError, velError));
        double dt = Duration.toDouble-impl((long)this.start.elapsedNow-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS);
        PoseVelocity2d vel = acc.integrateToVel(dt, actualVelActual);
        return LQRControllerKt.concat(vel, acc);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R, double dt, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this(A, B, Q, R, dt, maxIter, 0.0, 64, null);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R, double dt) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this(A, B, Q, R, dt, 0, 0.0, 96, null);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this(A, B, Q, R, 0.0, 0, 0.0, 112, null);
    }
}

