/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.Pose2d$;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d$;
import com.acmerobotics.roadrunner.geometry.Twist2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2d$;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\fB/\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0006\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0014J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u000eH\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001J%\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0001\u00a2\u0006\u0002\b.R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "", "position", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "heading", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Rotation2d;)V", "", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;D)V", "positionX", "positionY", "(DDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Rotation2d;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "plus", "t", "Lcom/acmerobotics/roadrunner/geometry/Twist2d;", "minusExp", "minus", "times", "p", "v", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "pv", "inverse", "log", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "Companion", "$serializer", "core"})
public final class Pose2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Vector2d position;
    @JvmField
    @NotNull
    public final Rotation2d heading;
    @JvmField
    @NotNull
    public static final Pose2d zero = new Pose2d(Vector2d.zero, Rotation2d.zero);

    public Pose2d(@NotNull Vector2d position, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        this.position = position;
        this.heading = heading;
    }

    public Pose2d(@NotNull Vector2d position, double heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(position, Rotation2d.Companion.exp(heading));
    }

    public Pose2d(double positionX, double positionY, double heading) {
        this(new Vector2d(positionX, positionY), heading);
    }

    @NotNull
    public final Pose2d plus(@NotNull Twist2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.times(Companion.exp(t));
    }

    @NotNull
    public final Pose2d minusExp(@NotNull Pose2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return t.inverse().times(this);
    }

    @NotNull
    public final Twist2d minus(@NotNull Pose2d t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.minusExp(t).log();
    }

    @NotNull
    public final Pose2d times(@NotNull Pose2d p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new Pose2d(this.heading.times(p.position).plus(this.position), this.heading.times(p.heading));
    }

    @NotNull
    public final Vector2d times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.heading.times(v).plus(this.position);
    }

    @NotNull
    public final PoseVelocity2d times(@NotNull PoseVelocity2d pv) {
        Intrinsics.checkNotNullParameter((Object)pv, (String)"pv");
        return new PoseVelocity2d(this.heading.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Pose2d inverse() {
        return new Pose2d(this.heading.inverse().times(this.position.unaryMinus()), this.heading.inverse());
    }

    @NotNull
    public final Twist2d log() {
        double theta = this.heading.log();
        double halfu = 0.5 * theta + Math.snz(theta);
        double v = halfu / java.lang.Math.tan(halfu);
        return new Twist2d(new Vector2d(v * this.position.x + halfu * this.position.y, -halfu * this.position.x + v * this.position.y), theta);
    }

    @NotNull
    public final Vector2d component1() {
        return this.position;
    }

    @NotNull
    public final Rotation2d component2() {
        return this.heading;
    }

    @NotNull
    public final Pose2d copy(@NotNull Vector2d position, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return new Pose2d(position, heading);
    }

    public static /* synthetic */ Pose2d copy$default(Pose2d pose2d, Vector2d vector2d, Rotation2d rotation2d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2d = pose2d.position;
        }
        if ((n & 2) != 0) {
            rotation2d = pose2d.heading;
        }
        return pose2d.copy(vector2d, rotation2d);
    }

    @NotNull
    public String toString() {
        return "Pose2d(position=" + this.position + ", heading=" + this.heading + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.heading.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pose2d)) {
            return false;
        }
        Pose2d pose2d = (Pose2d)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)pose2d.position)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.heading, (Object)pose2d.heading);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(Pose2d self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)Vector2d$.serializer.INSTANCE, (Object)self.position);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)Rotation2d$.serializer.INSTANCE, (Object)self.heading);
    }

    public /* synthetic */ Pose2d(int seen0, Vector2d position, Rotation2d heading, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.position = position;
        this.heading = heading;
    }

    @JvmStatic
    @NotNull
    public static final Pose2d exp(@NotNull Twist2d t) {
        return Companion.exp(t);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nR\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Pose2d$Companion;", "", "<init>", "()V", "exp", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "t", "Lcom/acmerobotics/roadrunner/geometry/Twist2d;", "zero", "serializer", "Lkotlinx/serialization/KSerializer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Pose2d exp(@NotNull Twist2d t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Rotation2d heading = Rotation2d.Companion.exp(t.angle);
            double u = t.angle + Math.snz(t.angle);
            double c = 1.0 - java.lang.Math.cos(u);
            double s = java.lang.Math.sin(u);
            Vector2d translation = new Vector2d((s * t.line.x - c * t.line.y) / u, (c * t.line.x + s * t.line.y) / u);
            return new Pose2d(translation, heading);
        }

        @NotNull
        public final KSerializer<Pose2d> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

