/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d$;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual;
import com.acmerobotics.roadrunner.paths.HeadingPath;
import com.acmerobotics.roadrunner.paths.QuinticSpline1d;
import com.acmerobotics.roadrunner.paths.QuinticSpline1d$;
import com.acmerobotics.roadrunner.paths.SplineHeadingPath$;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0002)*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rB7\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\b\u0010\u0012J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/acmerobotics/roadrunner/paths/SplineHeadingPath;", "Lcom/acmerobotics/roadrunner/paths/HeadingPath;", "begin", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "spline", "Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;", "length", "", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Rotation2d;Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;D)V", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "end", "(Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/acmerobotics/roadrunner/geometry/Rotation2d;Lcom/acmerobotics/roadrunner/paths/QuinticSpline1d;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "get", "s", "n", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
public final class SplineHeadingPath
implements HeadingPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Rotation2d begin;
    @JvmField
    @NotNull
    public final QuinticSpline1d spline;
    @JvmField
    public final double length;

    public SplineHeadingPath(@NotNull Rotation2d begin, @NotNull QuinticSpline1d spline, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        this.begin = begin;
        this.spline = spline;
        this.length = length;
    }

    public SplineHeadingPath(@NotNull Rotation2dDual<Arclength> begin, @NotNull Rotation2dDual<Arclength> end, double length) {
        Intrinsics.checkNotNullParameter(begin, (String)"begin");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        if (!(begin.size() >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit unit = Unit.INSTANCE;
        Rotation2d rotation2d = begin.value();
        SplineHeadingPath splineHeadingPath = this;
        boolean bl = false;
        if (!(end.size() >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit it = Unit.INSTANCE;
        boolean bl2 = false;
        DualNum s = DualNum.Companion.variable(1.0, 3).times(length);
        boolean bl3 = false;
        QuinticSpline1d quinticSpline1d = new QuinticSpline1d(DualNum.Companion.cons(0.0, begin.velocity()).reparam(s), DualNum.Companion.cons(end.value().minus(begin.value()), end.velocity()).reparam(s));
        splineHeadingPath(rotation2d, quinticSpline1d, length);
    }

    @Override
    @NotNull
    public Rotation2dDual<Arclength> get(double s, int n) {
        return Rotation2dDual.Companion.exp(this.spline.get(s / this.length, n).reparam(DualNum.Companion.variable(s, n).div(this.length))).times(this.begin);
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final Rotation2d component1() {
        return this.begin;
    }

    @NotNull
    public final QuinticSpline1d component2() {
        return this.spline;
    }

    public final double component3() {
        return this.length;
    }

    @NotNull
    public final SplineHeadingPath copy(@NotNull Rotation2d begin, @NotNull QuinticSpline1d spline, double length) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        return new SplineHeadingPath(begin, spline, length);
    }

    public static /* synthetic */ SplineHeadingPath copy$default(SplineHeadingPath splineHeadingPath, Rotation2d rotation2d, QuinticSpline1d quinticSpline1d, double d, int n, Object object) {
        if ((n & 1) != 0) {
            rotation2d = splineHeadingPath.begin;
        }
        if ((n & 2) != 0) {
            quinticSpline1d = splineHeadingPath.spline;
        }
        if ((n & 4) != 0) {
            d = splineHeadingPath.length;
        }
        return splineHeadingPath.copy(rotation2d, quinticSpline1d, d);
    }

    @NotNull
    public String toString() {
        return "SplineHeadingPath(begin=" + this.begin + ", spline=" + this.spline + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = this.begin.hashCode();
        result = result * 31 + this.spline.hashCode();
        result = result * 31 + Double.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplineHeadingPath)) {
            return false;
        }
        SplineHeadingPath splineHeadingPath = (SplineHeadingPath)other;
        if (!Intrinsics.areEqual((Object)this.begin, (Object)splineHeadingPath.begin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spline, (Object)splineHeadingPath.spline)) {
            return false;
        }
        return Double.compare(this.length, splineHeadingPath.length) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(SplineHeadingPath self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)Rotation2d$.serializer.INSTANCE, (Object)self.begin);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)QuinticSpline1d$.serializer.INSTANCE, (Object)self.spline);
        output.encodeDoubleElement(serialDesc, 2, self.length);
    }

    public /* synthetic */ SplineHeadingPath(int seen0, Rotation2d begin, QuinticSpline1d spline, double length, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.begin = begin;
        this.spline = spline;
        this.length = length;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/acmerobotics/roadrunner/paths/SplineHeadingPath$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/acmerobotics/roadrunner/paths/SplineHeadingPath;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<SplineHeadingPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

