/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.paths.CompositePosePath;
import com.acmerobotics.roadrunner.paths.CompositePositionPath;
import com.acmerobotics.roadrunner.paths.PositionPath;
import com.acmerobotics.roadrunner.trajectories.PathBuilder;
import com.acmerobotics.roadrunner.trajectories.PosePathSeqBuilder;
import com.acmerobotics.roadrunner.trajectories.PositionPathSeqBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BF\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012#\u0010\u0006\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u000b0\u0007\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0012J=\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052#\u0010\u0006\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u000b0\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0002J5\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052#\u0010\u0006\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u000b0\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\nJ\u0016\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\nJ\u0016\u0010(\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u00020\u0003J\u0016\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u00020\nJ\u0016\u00102\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u00020\u0003J\u0016\u00102\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u00020\nJ\u0016\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0003J\u0016\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00102\u0006\u00101\u001a\u00020\nJ\u0016\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0003J\u0016\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00102\u0006\u00101\u001a\u00020\nJ\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0006\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/PathBuilder;", "", "beginHeading", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "positionPathSeqBuilder", "Lcom/acmerobotics/roadrunner/trajectories/PositionPathSeqBuilder;", "headingSegments", "", "Lkotlin/Function2;", "Lcom/acmerobotics/roadrunner/trajectories/PosePathSeqBuilder;", "", "Lkotlin/ExtensionFunctionType;", "endHeading", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Rotation2d;Lcom/acmerobotics/roadrunner/trajectories/PositionPathSeqBuilder;Ljava/util/List;Lcom/acmerobotics/roadrunner/geometry/Rotation2d;)V", "beginPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "eps", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;D)V", "copy", "copyTangent", "setTangent", "r", "setReversed", "reversed", "", "forward", "ds", "forwardConstantHeading", "forwardLinearHeading", "heading", "forwardSplineHeading", "lineToX", "posX", "lineToXConstantHeading", "lineToXLinearHeading", "lineToXSplineHeading", "lineToY", "posY", "lineToYConstantHeading", "lineToYLinearHeading", "lineToYSplineHeading", "strafeTo", "pos", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "strafeToConstantHeading", "strafeToLinearHeading", "strafeToSplineHeading", "splineTo", "tangent", "splineToConstantHeading", "splineToLinearHeading", "pose", "splineToSplineHeading", "build", "Lcom/acmerobotics/roadrunner/paths/CompositePosePath;", "core"})
public final class PathBuilder {
    @NotNull
    private final Rotation2d beginHeading;
    @NotNull
    private final PositionPathSeqBuilder positionPathSeqBuilder;
    @NotNull
    private final List<Function2<PosePathSeqBuilder, Double, PosePathSeqBuilder>> headingSegments;
    @NotNull
    private final Rotation2d endHeading;

    private PathBuilder(Rotation2d beginHeading, PositionPathSeqBuilder positionPathSeqBuilder, List<? extends Function2<? super PosePathSeqBuilder, ? super Double, PosePathSeqBuilder>> headingSegments, Rotation2d endHeading) {
        this.beginHeading = beginHeading;
        this.positionPathSeqBuilder = positionPathSeqBuilder;
        this.headingSegments = headingSegments;
        this.endHeading = endHeading;
    }

    public PathBuilder(@NotNull Pose2d beginPose, double eps) {
        Intrinsics.checkNotNullParameter((Object)beginPose, (String)"beginPose");
        this(beginPose.heading, new PositionPathSeqBuilder(beginPose.position, beginPose.heading, eps), CollectionsKt.emptyList(), beginPose.heading);
    }

    private final PathBuilder copy(PositionPathSeqBuilder positionPathSeqBuilder, List<? extends Function2<? super PosePathSeqBuilder, ? super Double, PosePathSeqBuilder>> headingSegments, Rotation2d endHeading) {
        return new PathBuilder(this.beginHeading, positionPathSeqBuilder, headingSegments, endHeading);
    }

    private final PathBuilder copyTangent(PositionPathSeqBuilder positionPathSeqBuilder, List<? extends Function2<? super PosePathSeqBuilder, ? super Double, PosePathSeqBuilder>> headingSegments) {
        PositionPath lastSeg = (PositionPath)CollectionsKt.last(((CompositePositionPath)CollectionsKt.last(positionPathSeqBuilder.build())).paths);
        double headingDiff = lastSeg.end(2).drop(1).angleCast().value().minus(lastSeg.begin(2).drop(1).angleCast().value());
        return new PathBuilder(this.beginHeading, positionPathSeqBuilder, headingSegments, this.endHeading.plus(headingDiff));
    }

    @NotNull
    public final PathBuilder setTangent(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new PathBuilder(this.beginHeading, this.positionPathSeqBuilder.setTangent(r), this.headingSegments, this.endHeading);
    }

    @NotNull
    public final PathBuilder setTangent(double r) {
        return this.setTangent(Rotation2d.Companion.exp(r));
    }

    @NotNull
    public final PathBuilder setReversed(boolean reversed) {
        return this.setTangent(this.endHeading.plus(reversed ? Math.PI : 0.0));
    }

    @NotNull
    public final PathBuilder forward(double ds) {
        return this.copyTangent(this.positionPathSeqBuilder.forward(ds), CollectionsKt.plus((Collection)this.headingSegments, (Object)((Object)forward.1.INSTANCE)));
    }

    @NotNull
    public final PathBuilder forwardConstantHeading(double ds) {
        return this.copy(this.positionPathSeqBuilder.forward(ds), CollectionsKt.plus((Collection)this.headingSegments, (Object)((Object)forwardConstantHeading.1.INSTANCE)), this.endHeading);
    }

    @NotNull
    public final PathBuilder forwardLinearHeading(double ds, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.forward(ds), CollectionsKt.plus((Collection)this.headingSegments, (arg_0, arg_1) -> PathBuilder.forwardLinearHeading$lambda$0(heading, arg_0, arg_1)), heading);
    }

    @NotNull
    public final PathBuilder forwardLinearHeading(double ds, double heading) {
        return this.forwardLinearHeading(ds, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder forwardSplineHeading(double ds, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.forward(ds), CollectionsKt.plus((Collection)this.headingSegments, (arg_0, arg_1) -> PathBuilder.forwardSplineHeading$lambda$1(heading, arg_0, arg_1)), heading);
    }

    @NotNull
    public final PathBuilder forwardSplineHeading(double ds, double heading) {
        return this.forwardSplineHeading(ds, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder lineToX(double posX) {
        return this.copyTangent(this.positionPathSeqBuilder.lineToX(posX), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::lineToX$lambda$2)));
    }

    @NotNull
    public final PathBuilder lineToXConstantHeading(double posX) {
        return this.copy(this.positionPathSeqBuilder.lineToX(posX), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::lineToXConstantHeading$lambda$3)), this.endHeading);
    }

    @NotNull
    public final PathBuilder lineToXLinearHeading(double posX, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.lineToX(posX), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.lineToXLinearHeading$lambda$4(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder lineToXLinearHeading(double posX, double heading) {
        return this.lineToXLinearHeading(posX, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder lineToXSplineHeading(double posX, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.lineToX(posX), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.lineToXSplineHeading$lambda$5(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder lineToXSplineHeading(double posX, double heading) {
        return this.lineToXSplineHeading(posX, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder lineToY(double posY) {
        return this.copyTangent(this.positionPathSeqBuilder.lineToY(posY), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::lineToY$lambda$6)));
    }

    @NotNull
    public final PathBuilder lineToYConstantHeading(double posY) {
        return this.copy(this.positionPathSeqBuilder.lineToY(posY), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::lineToYConstantHeading$lambda$7)), this.endHeading);
    }

    @NotNull
    public final PathBuilder lineToYLinearHeading(double posY, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.lineToY(posY), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.lineToYLinearHeading$lambda$8(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder lineToYLinearHeading(double posY, double heading) {
        return this.lineToYLinearHeading(posY, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder lineToYSplineHeading(double posY, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.lineToY(posY), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.lineToYSplineHeading$lambda$9(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder lineToYSplineHeading(double posY, double heading) {
        return this.lineToYSplineHeading(posY, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder strafeTo(@NotNull Vector2d pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.copyTangent(this.positionPathSeqBuilder.strafeTo(pos), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::strafeTo$lambda$10)));
    }

    @NotNull
    public final PathBuilder strafeToConstantHeading(@NotNull Vector2d pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.copy(this.positionPathSeqBuilder.strafeTo(pos), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::strafeToConstantHeading$lambda$11)), this.endHeading);
    }

    @NotNull
    public final PathBuilder strafeToLinearHeading(@NotNull Vector2d pos, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.strafeTo(pos), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.strafeToLinearHeading$lambda$12(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder strafeToLinearHeading(@NotNull Vector2d pos, double heading) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.strafeToLinearHeading(pos, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder strafeToSplineHeading(@NotNull Vector2d pos, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return this.copy(this.positionPathSeqBuilder.strafeTo(pos), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.strafeToSplineHeading$lambda$13(heading, arg_0, arg_1))), heading);
    }

    @NotNull
    public final PathBuilder strafeToSplineHeading(@NotNull Vector2d pos, double heading) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.strafeToSplineHeading(pos, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final PathBuilder splineTo(@NotNull Vector2d pos, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        return this.copyTangent(this.positionPathSeqBuilder.splineTo(pos, tangent), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::splineTo$lambda$14)));
    }

    @NotNull
    public final PathBuilder splineTo(@NotNull Vector2d pos, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.splineTo(pos, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final PathBuilder splineToConstantHeading(@NotNull Vector2d pos, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        return this.copy(this.positionPathSeqBuilder.splineTo(pos, tangent), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf(PathBuilder::splineToConstantHeading$lambda$15)), this.endHeading);
    }

    @NotNull
    public final PathBuilder splineToConstantHeading(@NotNull Vector2d pos, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.splineToConstantHeading(pos, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final PathBuilder splineToLinearHeading(@NotNull Pose2d pose, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        return this.copy(this.positionPathSeqBuilder.splineTo(pose.position, tangent), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.splineToLinearHeading$lambda$16(pose, arg_0, arg_1))), pose.heading);
    }

    @NotNull
    public final PathBuilder splineToLinearHeading(@NotNull Pose2d pose, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        return this.splineToLinearHeading(pose, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final PathBuilder splineToSplineHeading(@NotNull Pose2d pose, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        return this.copy(this.positionPathSeqBuilder.splineTo(pose.position, tangent), CollectionsKt.plus((Collection)this.headingSegments, (Iterable)CollectionsKt.listOf((arg_0, arg_1) -> PathBuilder.splineToSplineHeading$lambda$17(pose, arg_0, arg_1))), pose.heading);
    }

    @NotNull
    public final PathBuilder splineToSplineHeading(@NotNull Pose2d pose, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        return this.splineToSplineHeading(pose, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final List<CompositePosePath> build() {
        List<CompositePositionPath<Arclength>> posPaths = this.positionPathSeqBuilder.build();
        int i = 0;
        List posePaths = new ArrayList();
        Rotation2d nextHeading = this.beginHeading;
        for (CompositePositionPath<Arclength> posPath : posPaths) {
            PosePathSeqBuilder posePathSeqBuilder = new PosePathSeqBuilder((PositionPath<Arclength>)posPath, nextHeading);
            Iterator iterator = CollectionsKt.drop((Iterable)posPath.offsets, (int)1).iterator();
            while (iterator.hasNext()) {
                double s = ((Number)iterator.next()).doubleValue();
                Function2<PosePathSeqBuilder, Double, PosePathSeqBuilder> headingSeg = this.headingSegments.get(i++);
                posePathSeqBuilder = (PosePathSeqBuilder)headingSeg.invoke((Object)posePathSeqBuilder, (Object)s);
            }
            posePaths.addAll((Collection)posePathSeqBuilder.build$core());
            nextHeading = ((CompositePosePath)CollectionsKt.last((List)posePaths)).end((int)1).value().heading;
        }
        return posePaths;
    }

    private static final PosePathSeqBuilder forwardLinearHeading$lambda$0(Rotation2d $heading, PosePathSeqBuilder posePathSeqBuilder, double it) {
        Intrinsics.checkNotNullParameter((Object)posePathSeqBuilder, (String)"<this>");
        return posePathSeqBuilder.linearUntil(it, $heading);
    }

    private static final PosePathSeqBuilder forwardSplineHeading$lambda$1(Rotation2d $heading, PosePathSeqBuilder posePathSeqBuilder, double it) {
        Intrinsics.checkNotNullParameter((Object)posePathSeqBuilder, (String)"<this>");
        return posePathSeqBuilder.splineUntil(it, $heading);
    }

    private static final PosePathSeqBuilder lineToX$lambda$2(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.tangentUntil(it);
    }

    private static final PosePathSeqBuilder lineToXConstantHeading$lambda$3(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.constantUntil(it);
    }

    private static final PosePathSeqBuilder lineToXLinearHeading$lambda$4(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.linearUntil(it, $heading);
    }

    private static final PosePathSeqBuilder lineToXSplineHeading$lambda$5(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.splineUntil(it, $heading);
    }

    private static final PosePathSeqBuilder lineToY$lambda$6(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.tangentUntil(it);
    }

    private static final PosePathSeqBuilder lineToYConstantHeading$lambda$7(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.constantUntil(it);
    }

    private static final PosePathSeqBuilder lineToYLinearHeading$lambda$8(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.linearUntil(it, $heading);
    }

    private static final PosePathSeqBuilder lineToYSplineHeading$lambda$9(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.splineUntil(it, $heading);
    }

    private static final PosePathSeqBuilder strafeTo$lambda$10(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.tangentUntil(it);
    }

    private static final PosePathSeqBuilder strafeToConstantHeading$lambda$11(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.constantUntil(it);
    }

    private static final PosePathSeqBuilder strafeToLinearHeading$lambda$12(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.linearUntil(it, $heading);
    }

    private static final PosePathSeqBuilder strafeToSplineHeading$lambda$13(Rotation2d $heading, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.splineUntil(it, $heading);
    }

    private static final PosePathSeqBuilder splineTo$lambda$14(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.tangentUntil(it);
    }

    private static final PosePathSeqBuilder splineToConstantHeading$lambda$15(PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.constantUntil(it);
    }

    private static final PosePathSeqBuilder splineToLinearHeading$lambda$16(Pose2d $pose, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.linearUntil(it, $pose.heading);
    }

    private static final PosePathSeqBuilder splineToSplineHeading$lambda$17(Pose2d $pose, PosePathSeqBuilder $this$listOf, double it) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return $this$listOf.splineUntil(it, $pose.heading);
    }
}

