/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.TimeProfile;
import com.acmerobotics.roadrunner.profiles.TimeProfile$;
import com.acmerobotics.roadrunner.trajectories.CancelableTrajectory;
import com.acmerobotics.roadrunner.trajectories.DisplacementTrajectory;
import com.acmerobotics.roadrunner.trajectories.TimeTrajectory$;
import com.acmerobotics.roadrunner.trajectories.Trajectory;
import java.lang.annotation.Annotation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Serializable
@SerialName(value="TimeTrajectory")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rB7\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0007\u0010\u0014J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\t\u001a\u00020\u0011H\u0096\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b%R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/acmerobotics/roadrunner/trajectories/TimeTrajectory;", "Lcom/acmerobotics/roadrunner/trajectories/Trajectory;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "profile", "Lcom/acmerobotics/roadrunner/profiles/TimeProfile;", "<init>", "(Lcom/acmerobotics/roadrunner/paths/PosePath;Lcom/acmerobotics/roadrunner/profiles/TimeProfile;)V", "t", "Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;", "(Lcom/acmerobotics/roadrunner/trajectories/CancelableTrajectory;)V", "Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;", "(Lcom/acmerobotics/roadrunner/trajectories/DisplacementTrajectory;)V", "seen0", "", "duration", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/acmerobotics/roadrunner/paths/PosePath;Lcom/acmerobotics/roadrunner/profiles/TimeProfile;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "wrtDisp", "wrtTime", "length", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "project", "query", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "init", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
public final class TimeTrajectory
implements Trajectory<Time> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final PosePath path;
    @JvmField
    @NotNull
    public final TimeProfile profile;
    @JvmField
    public final double duration;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public TimeTrajectory(@NotNull PosePath path, @NotNull TimeProfile profile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.path = path;
        this.profile = profile;
        this.duration = this.profile.duration;
    }

    public TimeTrajectory(@NotNull CancelableTrajectory t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this(t.path, new TimeProfile(t.cProfile.baseProfile, null, 2, null));
    }

    public TimeTrajectory(@NotNull DisplacementTrajectory t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this(t.path, new TimeProfile(t.profile, null, 2, null));
    }

    @Override
    @NotNull
    public DisplacementTrajectory wrtDisp() {
        return new DisplacementTrajectory(this.path, this.profile.dispProfile);
    }

    @Override
    @NotNull
    public TimeTrajectory wrtTime() {
        return this;
    }

    @Override
    public double length() {
        return this.path.length();
    }

    @Override
    @NotNull
    public Pose2dDual<Time> get(double t) {
        DualNum<Time> s = this.profile.get(t);
        return this.path.get(s.value(), 3).reparam(s);
    }

    @Override
    public double project(@NotNull Vector2d query, double init) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.path.project(query, init);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(TimeTrajectory self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.path);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)TimeProfile$.serializer.INSTANCE, (Object)self.profile);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : Double.compare(self.duration, self.profile.duration) != 0) {
            output.encodeDoubleElement(serialDesc, 2, self.duration);
        }
    }

    public /* synthetic */ TimeTrajectory(int seen0, PosePath path, TimeProfile profile, double duration, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.path = path;
        this.profile = profile;
        this.duration = (seen0 & 4) == 0 ? this.profile.duration : duration;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(PosePath.class), new Annotation[0])), null, null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/TimeTrajectory$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/acmerobotics/roadrunner/trajectories/TimeTrajectory;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<TimeTrajectory> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

