/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.control.RobotPosVelController;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bJ,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/acmerobotics/roadrunner/control/HolonomicController;", "Lcom/acmerobotics/roadrunner/control/RobotPosVelController;", "axialPosGain", "", "lateralPosGain", "headingGain", "axialVelGain", "lateralVelGain", "headingVelGain", "<init>", "(DDDDDD)V", "(DDD)V", "compute", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "targetPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "actualPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "actualVelActual", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2d;", "core"})
public final class HolonomicController
implements RobotPosVelController {
    @JvmField
    public final double axialPosGain;
    @JvmField
    public final double lateralPosGain;
    @JvmField
    public final double headingGain;
    @JvmField
    public final double axialVelGain;
    @JvmField
    public final double lateralVelGain;
    @JvmField
    public final double headingVelGain;

    public HolonomicController(double axialPosGain, double lateralPosGain, double headingGain, double axialVelGain, double lateralVelGain, double headingVelGain) {
        this.axialPosGain = axialPosGain;
        this.lateralPosGain = lateralPosGain;
        this.headingGain = headingGain;
        this.axialVelGain = axialVelGain;
        this.lateralVelGain = lateralVelGain;
        this.headingVelGain = headingVelGain;
    }

    public HolonomicController(double axialPosGain, double lateralPosGain, double headingGain) {
        this(axialPosGain, lateralPosGain, headingGain, 0.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        PoseVelocity2dDual<Time> targetVelWorld = targetPose.velocity();
        Pose2dDual<Time> txTargetWorld = Pose2dDual.Companion.constant(targetPose.value().inverse(), 2);
        PoseVelocity2dDual<Time> targetVelTarget = txTargetWorld.times(targetVelWorld);
        PoseVelocity2d velErrorActual = targetVelTarget.value().minus(actualVelActual);
        Pose2d error = targetPose.value().minusExp(actualPose);
        return targetVelTarget.plus(new PoseVelocity2d(new Vector2d(this.axialPosGain * error.position.x, this.lateralPosGain * error.position.y), this.headingGain * error.heading.log())).plus(new PoseVelocity2d(new Vector2d(this.axialVelGain * velErrorActual.linearVel.x, this.lateralVelGain * velErrorActual.linearVel.y), this.headingVelGain * velErrorActual.angVel));
    }
}

