/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Matrices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\u0004\b\u0005\u0010\tB)\b\u0016\u0012\u001e\u0010\u0002\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\"\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0005\u0010\nB\u0011\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0005\u0010\rJ\u0006\u0010\u0016\u001a\u00020\u0000J\t\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0012H\u0086\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u0019\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0086\u0002J!\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010#\u001a\u00020\bH\u0086\u0002J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020\u0000J\b\u0010(\u001a\u00020)H\u0016J\u0013\u0010*\u001a\u00020+2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010,\u001a\u00020\u0012H\u0016R\u0014\u0010\u000e\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/acmerobotics/roadrunner/geometry/Matrix;", "", "data", "", "", "<init>", "([[D)V", "", "", "(Ljava/util/Collection;)V", "([Ljava/util/Collection;)V", "matrix", "Lorg/ejml/simple/SimpleMatrix;", "(Lorg/ejml/simple/SimpleMatrix;)V", "simple", "getSimple$core", "()Lorg/ejml/simple/SimpleMatrix;", "numColumns", "", "numRows", "size", "Lkotlin/Pair;", "transpose", "unaryMinus", "plus", "other", "minus", "times", "scalar", "solve", "get", "i", "j", "set", "", "value", "row", "n", "column", "diagonals", "toString", "", "equals", "", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMatrices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrices.kt\ncom/acmerobotics/roadrunner/geometry/Matrix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,266:1\n1563#2:267\n1634#2,3:268\n37#3:271\n36#3,3:272\n37#3:279\n36#3,3:280\n11228#4:275\n11563#4,3:276\n*S KotlinDebug\n*F\n+ 1 Matrices.kt\ncom/acmerobotics/roadrunner/geometry/Matrix\n*L\n22#1:267\n22#1:268,3\n22#1:271\n22#1:272,3\n27#1:279\n27#1:280,3\n27#1:275\n27#1:276,3\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleMatrix simple;
    @JvmField
    public final int numColumns;
    @JvmField
    public final int numRows;
    @JvmField
    @NotNull
    public final Pair<Integer, Integer> size;

    public Matrix(@NotNull double[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.simple = new SimpleMatrix(data);
        this.numColumns = this.simple.getNumCols();
        this.numRows = this.simple.getNumRows();
        this.size = TuplesKt.to((Object)this.numRows, (Object)this.numColumns);
    }

    /*
     * WARNING - void declaration
     */
    public Matrix(@NotNull Collection<? extends Collection<Double>> data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable iterable = data;
        Matrix matrix = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection = (Collection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CollectionsKt.toDoubleArray((Collection)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        matrix((double[][])thisCollection$iv.toArray((T[])new double[0][]));
    }

    /*
     * WARNING - void declaration
     */
    public Matrix(Collection<Double> ... data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Collection<Double>[] collectionArray = data;
        Matrix matrix = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toDoubleArray((Collection)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        matrix((double[][])thisCollection$iv.toArray((T[])new double[0][]));
    }

    public Matrix(@NotNull SimpleMatrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        double[][] dArray = matrix.toArray2();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"toArray2(...)");
        this(dArray);
    }

    @NotNull
    public final SimpleMatrix getSimple$core() {
        return this.simple;
    }

    @NotNull
    public final Matrix transpose() {
        SimpleBase simpleBase = this.simple.transpose();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"transpose(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix unaryMinus() {
        return new Matrix(Matrices.unaryMinus(this.simple));
    }

    @NotNull
    public final Matrix plus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.plus((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"plus(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix minus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.minus((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"minus(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix times(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Matrix(Matrices.times(this.simple, other.simple));
    }

    @NotNull
    public final Matrix times(double scalar) {
        return new Matrix(Matrices.times(this.simple, scalar));
    }

    @NotNull
    public final Matrix times(int scalar) {
        return new Matrix(Matrices.times(this.simple, scalar));
    }

    @NotNull
    public final Matrix solve(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.solve((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"solve(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    public final double get(int i, int j) {
        return this.simple.get(i, j);
    }

    public final void set(int i, int j, double value) {
        this.simple.set(i, j, value);
    }

    @NotNull
    public final Matrix row(int n) {
        SimpleBase simpleBase = this.simple.getRow(n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"getRow(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix column(int n) {
        SimpleBase simpleBase = this.simple.getColumn(n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"getColumn(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix diagonals() {
        SimpleBase simpleBase = this.simple.diag();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"diag(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public String toString() {
        return ArraysKt.contentDeepToString((Object[])((Object[])this.simple.toArray2()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.acmerobotics.roadrunner.geometry.Matrix");
        Matrix cfr_ignored_0 = (Matrix)other;
        return this.simple.isIdentical((ConstMatrix)((Matrix)other).simple, 1.0E-6);
    }

    public int hashCode() {
        return this.simple.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final Matrix zero(int rows, int cols) {
        return Companion.zero(rows, cols);
    }

    @JvmStatic
    @NotNull
    public static final Matrix zero(int size) {
        return Companion.zero(size);
    }

    @JvmStatic
    @NotNull
    public static final Matrix identity(int size) {
        return Companion.identity(size);
    }

    @JvmStatic
    @NotNull
    public static final Matrix diagonal(double ... data) {
        return Companion.diagonal(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix diagonal(@NotNull Collection<Double> data) {
        return Companion.diagonal(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix row(double ... data) {
        return Companion.row(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix row(@NotNull Collection<Double> data) {
        return Companion.row(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix column(double ... data) {
        return Companion.column(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix column(@NotNull Collection<Double> data) {
        return Companion.column(data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0014\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007J\u0014\u0010\u0010\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007J\u0014\u0010\u0011\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Matrix$Companion;", "", "<init>", "()V", "zero", "Lcom/acmerobotics/roadrunner/geometry/Matrix;", "rows", "", "cols", "size", "identity", "diagonal", "data", "", "", "", "row", "column", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Matrix zero(int rows, int cols) {
            return new Matrix(new SimpleMatrix(rows, cols));
        }

        @JvmStatic
        @NotNull
        public final Matrix zero(int size) {
            return this.zero(size, size);
        }

        @JvmStatic
        @NotNull
        public final Matrix identity(int size) {
            SimpleMatrix simpleMatrix = SimpleMatrix.identity((int)size);
            Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"identity(...)");
            return new Matrix(simpleMatrix);
        }

        @JvmStatic
        @NotNull
        public final Matrix diagonal(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            SimpleMatrix simpleMatrix = SimpleMatrix.diag((double[])Arrays.copyOf(data, data.length));
            Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"diag(...)");
            return new Matrix(simpleMatrix);
        }

        @JvmStatic
        @NotNull
        public final Matrix diagonal(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.diagonal(Arrays.copyOf(dArray, dArray.length));
        }

        @JvmStatic
        @NotNull
        public final Matrix row(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Matrix(new SimpleMatrix(1, data.length, true, Arrays.copyOf(data, data.length)));
        }

        @JvmStatic
        @NotNull
        public final Matrix row(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.row(Arrays.copyOf(dArray, dArray.length));
        }

        @JvmStatic
        @NotNull
        public final Matrix column(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Matrix(new SimpleMatrix(data.length, 1, false, Arrays.copyOf(data, data.length)));
        }

        @JvmStatic
        @NotNull
        public final Matrix column(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.column(Arrays.copyOf(dArray, dArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

