/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.paths;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.paths.HeadingPath;
import com.acmerobotics.roadrunner.paths.LinearHeadingPath;
import com.acmerobotics.roadrunner.paths.PosePath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/acmerobotics/roadrunner/paths/TurnPath;", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "position", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "headingPath", "Lcom/acmerobotics/roadrunner/paths/HeadingPath;", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/paths/HeadingPath;)V", "start", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "endAngle", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;Lcom/acmerobotics/roadrunner/geometry/Rotation2d;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "s", "", "n", "", "length", "core"})
public final class TurnPath
implements PosePath {
    @JvmField
    @NotNull
    public final Vector2d position;
    @JvmField
    @NotNull
    public final HeadingPath headingPath;

    public TurnPath(@NotNull Vector2d position, @NotNull HeadingPath headingPath) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)headingPath, (String)"headingPath");
        this.position = position;
        this.headingPath = headingPath;
    }

    public TurnPath(@NotNull Pose2d start, @NotNull Rotation2d endAngle) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endAngle, (String)"endAngle");
        this(start.position, new LinearHeadingPath(start.heading, endAngle.log(), start.heading.minus(endAngle)));
    }

    @Override
    @NotNull
    public Pose2dDual<Arclength> get(double s, int n) {
        return new Pose2dDual<Arclength>(Vector2dDual.Companion.constant(this.position, n), this.headingPath.get(s, n));
    }

    @Override
    public double length() {
        return this.headingPath.length();
    }
}

