/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.VelConstraint;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/acmerobotics/roadrunner/profiles/AngularVelConstraint;", "Lcom/acmerobotics/roadrunner/profiles/VelConstraint;", "maxAngVel", "", "<init>", "(D)V", "maxRobotVel", "robotPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "s", "core"})
@SourceDebugExtension(value={"SMAP\nConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constraints.kt\ncom/acmerobotics/roadrunner/profiles/AngularVelConstraint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class AngularVelConstraint
implements VelConstraint {
    @JvmField
    public final double maxAngVel;

    public AngularVelConstraint(double maxAngVel) {
        this.maxAngVel = maxAngVel;
        if (!(this.maxAngVel > 0.0)) {
            boolean bl = false;
            String string = "maxAngVel (" + this.maxAngVel + ") must be positive";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public double maxRobotVel(@NotNull Pose2dDual<Arclength> robotPose, @NotNull PosePath path, double s) {
        Intrinsics.checkNotNullParameter(robotPose, (String)"robotPose");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Math.abs(this.maxAngVel / robotPose.heading.velocity().value());
    }
}

