/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.MinMax;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.AccelConstraint;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/acmerobotics/roadrunner/profiles/CompositeAccelConstraint;", "Lcom/acmerobotics/roadrunner/profiles/AccelConstraint;", "constraints", "", "offsets", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "minMaxProfileAccel", "Lcom/acmerobotics/roadrunner/geometry/MinMax;", "robotPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Arclength;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "s", "core"})
public final class CompositeAccelConstraint
implements AccelConstraint {
    @JvmField
    @NotNull
    public final List<AccelConstraint> constraints;
    @JvmField
    @NotNull
    public final List<Double> offsets;

    public CompositeAccelConstraint(@NotNull List<? extends AccelConstraint> constraints, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.constraints = constraints;
        this.offsets = offsets;
        if (!(this.constraints.size() + 1 == this.offsets.size())) {
            boolean bl = false;
            String string = "constraints.size() (" + this.constraints.size() + ") + 1 != offsets.size() (" + this.offsets.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public MinMax minMaxProfileAccel(@NotNull Pose2dDual<Arclength> robotPose, @NotNull PosePath path, double s) {
        Intrinsics.checkNotNullParameter(robotPose, (String)"robotPose");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        for (Pair pair : CollectionsKt.reversed((Iterable)CollectionsKt.drop((Iterable)CollectionsKt.zip((Iterable)this.offsets, (Iterable)this.constraints), (int)1))) {
            double offset = ((Number)pair.component1()).doubleValue();
            AccelConstraint constraint = (AccelConstraint)pair.component2();
            if (!(s >= offset)) continue;
            return constraint.minMaxProfileAccel(robotPose, path, s);
        }
        return ((AccelConstraint)CollectionsKt.first(this.constraints)).minMaxProfileAccel(robotPose, path, s);
    }
}

