/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile$;
import com.acmerobotics.roadrunner.profiles.Profile;
import com.acmerobotics.roadrunner.profiles.Profiles;
import com.acmerobotics.roadrunner.profiles.TimeProfile$;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="TimeProfile")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB=\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/acmerobotics/roadrunner/profiles/TimeProfile;", "Lcom/acmerobotics/roadrunner/profiles/Profile;", "dispProfile", "Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "times", "", "", "<init>", "(Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;Ljava/util/List;)V", "seen0", "", "duration", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/acmerobotics/roadrunner/profiles/DisplacementProfile;Ljava/util/List;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "t", "inverse", "x", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
public final class TimeProfile
implements Profile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final DisplacementProfile dispProfile;
    @JvmField
    @NotNull
    public final List<Double> times;
    @JvmField
    public final double duration;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    @JvmOverloads
    public TimeProfile(@NotNull DisplacementProfile dispProfile, @NotNull List<Double> times) {
        Intrinsics.checkNotNullParameter((Object)dispProfile, (String)"dispProfile");
        Intrinsics.checkNotNullParameter(times, (String)"times");
        this.dispProfile = dispProfile;
        this.times = times;
        this.duration = ((Number)CollectionsKt.last(this.times)).doubleValue();
        if (!(this.times.size() == this.dispProfile.disps.size())) {
            boolean bl = false;
            String string = "times.size() (" + this.times.size() + ") != dispProfile.disps.size() (" + this.dispProfile.disps.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TimeProfile(DisplacementProfile displacementProfile, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = Profiles.access$timeScan(displacementProfile);
        }
        this(displacementProfile, list);
    }

    @Override
    @NotNull
    public DualNum<Time> get(double t) {
        DualNum dualNum;
        int index = CollectionsKt.binarySearch$default(this.times, (Comparable)Double.valueOf(t), (int)0, (int)0, (int)6, null);
        if (index >= CollectionsKt.getLastIndex(this.times)) {
            double[] dArray = new double[]{((Number)this.dispProfile.disps.get(index)).doubleValue(), ((Number)this.dispProfile.vels.get(index)).doubleValue(), 0.0};
            DualNum dualNum2 = new DualNum(dArray);
            dualNum = dualNum2;
        } else if (index >= 0) {
            double[] dArray = new double[]{((Number)this.dispProfile.disps.get(index)).doubleValue(), ((Number)this.dispProfile.vels.get(index)).doubleValue(), ((Number)this.dispProfile.accels.get(index)).doubleValue()};
            DualNum dualNum3 = new DualNum(dArray);
            dualNum = dualNum3;
        } else {
            int insIndex = -(index + 1);
            if (insIndex <= 0) {
                double v = ((Number)CollectionsKt.first(this.dispProfile.vels)).doubleValue();
                double[] dArray = new double[]{v * t, v, 0.0};
                DualNum dualNum4 = new DualNum(dArray);
                dualNum = dualNum4;
            } else if (insIndex >= this.times.size()) {
                double v = ((Number)CollectionsKt.last(this.dispProfile.vels)).doubleValue();
                double[] dArray = new double[]{this.dispProfile.length + v * (t - this.duration), v, 0.0};
                DualNum dualNum5 = new DualNum(dArray);
                dualNum = dualNum5;
            } else {
                double dt = t - ((Number)this.times.get(insIndex - 1)).doubleValue();
                double x0 = ((Number)this.dispProfile.disps.get(insIndex - 1)).doubleValue();
                double v0 = ((Number)this.dispProfile.vels.get(insIndex - 1)).doubleValue();
                double a = ((Number)this.dispProfile.accels.get(insIndex - 1)).doubleValue();
                double[] dArray = new double[]{(0.5 * a * dt + v0) * dt + x0, a * dt + v0, a};
                DualNum dualNum6 = new DualNum(dArray);
                dualNum = dualNum6;
            }
        }
        return dualNum;
    }

    public final double inverse(double x) {
        double d;
        int index = CollectionsKt.binarySearch$default(this.dispProfile.disps, (Comparable)Double.valueOf(x), (int)0, (int)0, (int)6, null);
        if (index >= CollectionsKt.getLastIndex(this.dispProfile.disps)) {
            d = ((Number)this.times.get(index)).doubleValue();
        } else if (index >= 0) {
            d = ((Number)this.times.get(index)).doubleValue();
        } else {
            int insIndex = -(index + 1);
            if (insIndex <= 0) {
                d = 0.0;
            } else if (insIndex >= this.times.size()) {
                d = this.duration;
            } else {
                double dx = x - ((Number)this.dispProfile.disps.get(insIndex - 1)).doubleValue();
                double t0 = ((Number)this.times.get(insIndex - 1)).doubleValue();
                double v0 = ((Number)this.dispProfile.vels.get(insIndex - 1)).doubleValue();
                double a = ((Number)this.dispProfile.accels.get(insIndex - 1)).doubleValue();
                d = a == 0.0 ? t0 + dx / v0 : t0 + Math.copySign(Math.sqrt((v0 * v0 / a + (double)2 * dx) / a), a) - v0 / a;
            }
        }
        return d;
    }

    @NotNull
    public final DisplacementProfile component1() {
        return this.dispProfile;
    }

    @NotNull
    public final List<Double> component2() {
        return this.times;
    }

    @NotNull
    public final TimeProfile copy(@NotNull DisplacementProfile dispProfile, @NotNull List<Double> times) {
        Intrinsics.checkNotNullParameter((Object)dispProfile, (String)"dispProfile");
        Intrinsics.checkNotNullParameter(times, (String)"times");
        return new TimeProfile(dispProfile, times);
    }

    public static /* synthetic */ TimeProfile copy$default(TimeProfile timeProfile, DisplacementProfile displacementProfile, List list, int n, Object object) {
        if ((n & 1) != 0) {
            displacementProfile = timeProfile.dispProfile;
        }
        if ((n & 2) != 0) {
            list = timeProfile.times;
        }
        return timeProfile.copy(displacementProfile, list);
    }

    @NotNull
    public String toString() {
        return "TimeProfile(dispProfile=" + this.dispProfile + ", times=" + this.times + ")";
    }

    public int hashCode() {
        int result = this.dispProfile.hashCode();
        result = result * 31 + ((Object)this.times).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeProfile)) {
            return false;
        }
        TimeProfile timeProfile = (TimeProfile)other;
        if (!Intrinsics.areEqual((Object)this.dispProfile, (Object)timeProfile.dispProfile)) {
            return false;
        }
        return Intrinsics.areEqual(this.times, timeProfile.times);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(TimeProfile self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)DisplacementProfile$.serializer.INSTANCE, (Object)self.dispProfile);
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.times, (Object)Profiles.access$timeScan(self.dispProfile))) {
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.times);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : Double.compare(self.duration, ((Number)CollectionsKt.last(self.times)).doubleValue()) != 0) {
            output.encodeDoubleElement(serialDesc, 2, self.duration);
        }
    }

    public /* synthetic */ TimeProfile(int seen0, DisplacementProfile dispProfile, List times, double duration, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.dispProfile = dispProfile;
        this.times = (seen0 & 2) == 0 ? Profiles.access$timeScan(this.dispProfile) : times;
        this.duration = (seen0 & 4) == 0 ? ((Number)CollectionsKt.last(this.times)).doubleValue() : duration;
        if (!(this.times.size() == this.dispProfile.disps.size())) {
            boolean bl = false;
            String string = "times.size() (" + this.times.size() + ") != dispProfile.disps.size() (" + this.dispProfile.disps.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmOverloads
    public TimeProfile(@NotNull DisplacementProfile dispProfile) {
        Intrinsics.checkNotNullParameter((Object)dispProfile, (String)"dispProfile");
        this(dispProfile, null, 2, null);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/acmerobotics/roadrunner/profiles/TimeProfile$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/acmerobotics/roadrunner/profiles/TimeProfile;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<TimeProfile> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

