/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.paths.CompositePosePath;
import com.acmerobotics.roadrunner.trajectories.PathBuilder;
import com.acmerobotics.roadrunner.trajectories.SafePathBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/RestrictedPathBuilder;", "", "pathBuilder", "Lcom/acmerobotics/roadrunner/trajectories/PathBuilder;", "<init>", "(Lcom/acmerobotics/roadrunner/trajectories/PathBuilder;)V", "lineToXSplineHeading", "Lcom/acmerobotics/roadrunner/trajectories/SafePathBuilder;", "posX", "", "heading", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "lineToYSplineHeading", "posY", "splineToSplineHeading", "pose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "tangent", "build", "", "Lcom/acmerobotics/roadrunner/paths/CompositePosePath;", "core"})
public final class RestrictedPathBuilder {
    @NotNull
    private final PathBuilder pathBuilder;

    public RestrictedPathBuilder(@NotNull PathBuilder pathBuilder) {
        Intrinsics.checkNotNullParameter((Object)pathBuilder, (String)"pathBuilder");
        this.pathBuilder = pathBuilder;
    }

    @NotNull
    public final SafePathBuilder lineToXSplineHeading(double posX, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return new SafePathBuilder(this.pathBuilder.lineToXSplineHeading(posX, heading));
    }

    @NotNull
    public final SafePathBuilder lineToXSplineHeading(double posX, double heading) {
        return this.lineToXSplineHeading(posX, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final SafePathBuilder lineToYSplineHeading(double posY, @NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        return new SafePathBuilder(this.pathBuilder.lineToYSplineHeading(posY, heading));
    }

    @NotNull
    public final SafePathBuilder lineToYSplineHeading(double posY, double heading) {
        return this.lineToYSplineHeading(posY, Rotation2d.Companion.exp(heading));
    }

    @NotNull
    public final SafePathBuilder splineToSplineHeading(@NotNull Pose2d pose, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        return new SafePathBuilder(this.pathBuilder.splineToSplineHeading(pose, tangent));
    }

    @NotNull
    public final SafePathBuilder splineToSplineHeading(@NotNull Pose2d pose, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        return this.splineToSplineHeading(pose, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final List<CompositePosePath> build() {
        return this.pathBuilder.build();
    }
}

