/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectories;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import com.acmerobotics.roadrunner.profiles.Profiles;
import com.acmerobotics.roadrunner.profiles.TimeProfile;
import com.acmerobotics.roadrunner.trajectories.TurnConstraints;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0086\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/acmerobotics/roadrunner/trajectories/TimeTurn;", "", "beginPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "angle", "", "constraints", "Lcom/acmerobotics/roadrunner/trajectories/TurnConstraints;", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;DLcom/acmerobotics/roadrunner/trajectories/TurnConstraints;)V", "profile", "Lcom/acmerobotics/roadrunner/profiles/TimeProfile;", "duration", "reversed", "", "get", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "t", "core"})
public final class TimeTurn {
    @JvmField
    @NotNull
    public final Pose2d beginPose;
    @JvmField
    public final double angle;
    @JvmField
    @NotNull
    public final TurnConstraints constraints;
    @JvmField
    @NotNull
    public final TimeProfile profile;
    @JvmField
    public final double duration;
    @JvmField
    public final boolean reversed;

    public TimeTurn(@NotNull Pose2d beginPose, double angle, @NotNull TurnConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)beginPose, (String)"beginPose");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.beginPose = beginPose;
        this.angle = angle;
        this.constraints = constraints;
        this.profile = new TimeProfile(Profiles.constantProfile((double)Math.abs((double)this.angle), (double)0.0, (double)this.constraints.maxAngVel, (double)this.constraints.minAngAccel, (double)this.constraints.maxAngAccel).baseProfile, null, 2, null);
        this.duration = this.profile.duration;
        this.reversed = this.angle < 0.0;
    }

    @NotNull
    public final Pose2dDual<Time> get(double t) {
        DualNum<Time> x = this.profile.get(t);
        return new Pose2dDual<Time>(Vector2dDual.Companion.constant(this.beginPose.position, x.size()), Rotation2dDual.Companion.exp(this.reversed ? x.unaryMinus() : x).times(this.beginPose.heading));
    }
}

